/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.criteria.predicate;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.hibernate.jpa.criteria.CriteriaBuilderImpl;
import org.hibernate.jpa.criteria.ParameterContainer;
import org.hibernate.jpa.criteria.ParameterRegistry;
import org.hibernate.jpa.criteria.Renderable;
import org.hibernate.jpa.criteria.compile.RenderingContext;
import org.hibernate.jpa.criteria.expression.LiteralExpression;
import org.hibernate.jpa.criteria.predicate.AbstractSimplePredicate;

public class LikePredicate
extends AbstractSimplePredicate
implements Serializable {
    private final Expression<String> matchExpression;
    private final Expression<String> pattern;
    private final Expression<Character> escapeCharacter;

    public LikePredicate(CriteriaBuilderImpl criteriaBuilder, Expression<String> matchExpression, Expression<String> pattern) {
        this(criteriaBuilder, matchExpression, pattern, null);
    }

    public LikePredicate(CriteriaBuilderImpl criteriaBuilder, Expression<String> matchExpression, String pattern) {
        this(criteriaBuilder, matchExpression, new LiteralExpression<String>(criteriaBuilder, pattern));
    }

    public LikePredicate(CriteriaBuilderImpl criteriaBuilder, Expression<String> matchExpression, Expression<String> pattern, Expression<Character> escapeCharacter) {
        super(criteriaBuilder);
        this.matchExpression = matchExpression;
        this.pattern = pattern;
        this.escapeCharacter = escapeCharacter;
    }

    public LikePredicate(CriteriaBuilderImpl criteriaBuilder, Expression<String> matchExpression, Expression<String> pattern, char escapeCharacter) {
        this(criteriaBuilder, matchExpression, pattern, new LiteralExpression<Character>(criteriaBuilder, Character.valueOf(escapeCharacter)));
    }

    public LikePredicate(CriteriaBuilderImpl criteriaBuilder, Expression<String> matchExpression, String pattern, char escapeCharacter) {
        this(criteriaBuilder, matchExpression, new LiteralExpression<String>(criteriaBuilder, pattern), new LiteralExpression<Character>(criteriaBuilder, Character.valueOf(escapeCharacter)));
    }

    public LikePredicate(CriteriaBuilderImpl criteriaBuilder, Expression<String> matchExpression, String pattern, Expression<Character> escapeCharacter) {
        this(criteriaBuilder, matchExpression, new LiteralExpression<String>(criteriaBuilder, pattern), escapeCharacter);
    }

    public Expression<Character> getEscapeCharacter() {
        return this.escapeCharacter;
    }

    public Expression<String> getMatchExpression() {
        return this.matchExpression;
    }

    public Expression<String> getPattern() {
        return this.pattern;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getEscapeCharacter(), registry);
        ParameterContainer.Helper.possibleParameter(this.getMatchExpression(), registry);
        ParameterContainer.Helper.possibleParameter(this.getPattern(), registry);
    }

    @Override
    public String render(boolean isNegated, RenderingContext renderingContext) {
        String operator2 = isNegated ? " not like " : " like ";
        StringBuilder buffer = new StringBuilder();
        buffer.append(((Renderable)((Object)this.getMatchExpression())).render(renderingContext)).append(operator2).append(((Renderable)((Object)this.getPattern())).render(renderingContext));
        if (this.escapeCharacter != null) {
            buffer.append(" escape ").append(((Renderable)((Object)this.getEscapeCharacter())).render(renderingContext));
        }
        return buffer.toString();
    }
}

