/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.dev;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.poifs.dev.POIFSViewEngine;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public class POIFSViewer {
    public static void main(String[] args) {
        if (args.length < 0) {
            System.err.println("Must specify at least one file to view");
            System.exit(1);
        }
        boolean printNames = args.length > 1;
        for (int j = 0; j < args.length; ++j) {
            POIFSViewer.viewFile(args[j], printNames);
        }
    }

    private static void viewFile(String filename, boolean printName) {
        if (printName) {
            StringBuffer flowerbox = new StringBuffer();
            flowerbox.append(".");
            for (int j = 0; j < filename.length(); ++j) {
                flowerbox.append("-");
            }
            flowerbox.append(".");
            System.out.println(flowerbox);
            System.out.println("|" + filename + "|");
            System.out.println(flowerbox);
        }
        try {
            POIFSFileSystem fs = new POIFSFileSystem(new FileInputStream(filename));
            List<String> strings = POIFSViewEngine.inspectViewable(fs, true, 0, "  ");
            Iterator<String> iter = strings.iterator();
            while (iter.hasNext()) {
                System.out.print(iter.next());
            }
        }
        catch (IOException e) {
            System.out.println(e.getMessage());
        }
    }
}

