/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.parsing;

import org.apache.ibatis.parsing.TokenHandler;

public class GenericTokenParser {
    private final String openToken;
    private final String closeToken;
    private final TokenHandler handler;

    public GenericTokenParser(String openToken, String closeToken, TokenHandler handler) {
        this.openToken = openToken;
        this.closeToken = closeToken;
        this.handler = handler;
    }

    public String parse(String text) {
        StringBuilder builder = new StringBuilder();
        if (text != null) {
            String after = text;
            int start = after.indexOf(this.openToken);
            int end = after.indexOf(this.closeToken);
            while (start > -1) {
                String before;
                if (end > start) {
                    before = after.substring(0, start);
                    String content = after.substring(start + this.openToken.length(), end);
                    String substitution = this.handler.handleToken(content);
                    builder.append(before);
                    builder.append(substitution);
                    after = after.substring(end + this.closeToken.length());
                } else {
                    if (end <= -1) break;
                    before = after.substring(0, end);
                    builder.append(before);
                    builder.append(this.closeToken);
                    after = after.substring(end + this.closeToken.length());
                }
                start = after.indexOf(this.openToken);
                end = after.indexOf(this.closeToken);
            }
            builder.append(after);
        }
        return builder.toString();
    }
}

