/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.jdbc;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ibatis.jdbc.RuntimeSqlException;

public class ScriptRunner {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private static final String DEFAULT_DELIMITER = ";";
    private Connection connection;
    private boolean stopOnError;
    private boolean autoCommit;
    private boolean sendFullScript;
    private PrintWriter logWriter = new PrintWriter(System.out);
    private PrintWriter errorLogWriter = new PrintWriter(System.err);
    private String delimiter = ";";
    private boolean fullLineDelimiter = false;
    private String characterSetName;

    public ScriptRunner(Connection connection) {
        this.connection = connection;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public void setSendFullScript(boolean sendFullScript) {
        this.sendFullScript = sendFullScript;
    }

    public void setLogWriter(PrintWriter logWriter) {
        this.logWriter = logWriter;
    }

    public void setErrorLogWriter(PrintWriter errorLogWriter) {
        this.errorLogWriter = errorLogWriter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void setFullLineDelimiter(boolean fullLineDelimiter) {
        this.fullLineDelimiter = fullLineDelimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(Reader reader) {
        this.setAutoCommit();
        try {
            if (this.sendFullScript) {
                this.executeFullScript(reader);
            } else {
                this.executeLineByLine(reader);
            }
        }
        finally {
            this.rollbackConnection();
        }
    }

    private void executeFullScript(Reader reader) {
        StringBuffer script = new StringBuffer();
        try {
            String line;
            BufferedReader lineReader = new BufferedReader(reader);
            while ((line = lineReader.readLine()) != null) {
                script.append(line);
                script.append(LINE_SEPARATOR);
            }
            this.executeStatement(script.toString());
            this.commitConnection();
        }
        catch (Exception e) {
            String message = "Error executing: " + script + ".  Cause: " + e;
            this.printlnError(message);
            throw new RuntimeSqlException(message, e);
        }
    }

    private void executeLineByLine(Reader reader) {
        StringBuffer command = new StringBuffer();
        try {
            String line;
            BufferedReader lineReader = new BufferedReader(reader);
            while ((line = lineReader.readLine()) != null) {
                command = this.handleLine(command, line);
            }
            this.commitConnection();
            this.checkForMissingLineTerminator(command);
        }
        catch (Exception e) {
            String message = "Error executing: " + command + ".  Cause: " + e;
            this.printlnError(message);
            throw new RuntimeSqlException(message, e);
        }
    }

    public void closeConnection() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setAutoCommit() {
        try {
            if (this.autoCommit != this.connection.getAutoCommit()) {
                this.connection.setAutoCommit(this.autoCommit);
            }
        }
        catch (Throwable t) {
            throw new RuntimeSqlException("Could not set AutoCommit to " + this.autoCommit + ". Cause: " + t, t);
        }
    }

    private void commitConnection() {
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.commit();
            }
        }
        catch (Throwable t) {
            throw new RuntimeSqlException("Could not commit transaction. Cause: " + t, t);
        }
    }

    private void rollbackConnection() {
        try {
            if (!this.connection.getAutoCommit()) {
                this.connection.rollback();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void checkForMissingLineTerminator(StringBuffer command) {
        if (command != null && command.toString().trim().length() > 0) {
            throw new RuntimeSqlException("Line missing end-of-line terminator (" + this.delimiter + ") => " + command);
        }
    }

    private StringBuffer handleLine(StringBuffer command, String line) throws SQLException, UnsupportedEncodingException {
        String trimmedLine = line.trim();
        if (this.lineIsComment(trimmedLine)) {
            this.println(trimmedLine);
        } else if (this.commandReadyToExecute(trimmedLine)) {
            command.append(line.substring(0, line.lastIndexOf(this.delimiter)));
            command.append(LINE_SEPARATOR);
            this.println(command);
            this.executeStatement(command.toString());
            command.setLength(0);
        } else if (trimmedLine.length() > 0) {
            command.append(line);
            command.append(LINE_SEPARATOR);
        }
        return command;
    }

    private boolean lineIsComment(String trimmedLine) {
        return trimmedLine.startsWith("//") || trimmedLine.startsWith("--");
    }

    private boolean commandReadyToExecute(String trimmedLine) {
        return !this.fullLineDelimiter && trimmedLine.endsWith(this.delimiter) || this.fullLineDelimiter && trimmedLine.equals(this.delimiter);
    }

    private void executeStatement(String command) throws SQLException, UnsupportedEncodingException {
        if (this.characterSetName != null) {
            command = new String(command.getBytes(), this.characterSetName);
        }
        boolean hasResults = false;
        Statement statement = this.connection.createStatement();
        if (this.stopOnError) {
            hasResults = statement.execute(command);
        } else {
            try {
                hasResults = statement.execute(command);
            }
            catch (SQLException e) {
                String message = "Error executing: " + command + ".  Cause: " + e;
                this.printlnError(message);
            }
        }
        this.printResults(statement, hasResults);
        try {
            statement.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.commitConnection();
    }

    private void printResults(Statement statement, boolean hasResults) {
        try {
            ResultSet rs;
            if (hasResults && (rs = statement.getResultSet()) != null) {
                int i;
                ResultSetMetaData md = rs.getMetaData();
                int cols = md.getColumnCount();
                for (i = 0; i < cols; ++i) {
                    String name = md.getColumnLabel(i + 1);
                    this.print(name + "\t");
                }
                this.println("");
                while (rs.next()) {
                    for (i = 0; i < cols; ++i) {
                        String value = rs.getString(i + 1);
                        this.print(value + "\t");
                    }
                    this.println("");
                }
            }
        }
        catch (SQLException e) {
            this.printlnError("Error printing results: " + e.getMessage());
        }
    }

    private void print(Object o) {
        if (this.logWriter != null) {
            this.logWriter.print(o);
            this.logWriter.flush();
        }
    }

    private void println(Object o) {
        if (this.logWriter != null) {
            this.logWriter.println(o);
            this.logWriter.flush();
        }
    }

    private void printlnError(Object o) {
        if (this.errorLogWriter != null) {
            this.errorLogWriter.println(o);
            this.errorLogWriter.flush();
        }
    }
}

