/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.executor.loader;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.ibatis.executor.loader.ResultLoaderMap;
import org.apache.ibatis.reflection.ExceptionUtil;
import org.apache.ibatis.reflection.property.PropertyNamer;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class ResultObjectProxy {
    private static final Set<String> objectMethods = new HashSet<String>(Arrays.asList("equals", "hashCode", "toString"));
    private static final TypeHandlerRegistry registry = new TypeHandlerRegistry();

    public static Object createProxy(Object target, ResultLoaderMap lazyLoader, boolean aggressive) {
        return EnhancedResultObjectProxyImpl.createProxy(target, lazyLoader, aggressive);
    }

    private static class EnhancedResultObjectProxyImpl
    implements MethodInterceptor,
    Serializable {
        private ResultLoaderMap lazyLoader;
        private boolean aggressive;

        private EnhancedResultObjectProxyImpl(ResultLoaderMap lazyLoader, boolean aggressive) {
            this.lazyLoader = lazyLoader;
            this.aggressive = aggressive;
        }

        public static Object createProxy(Object target, ResultLoaderMap lazyLoader, boolean aggressive) {
            Class<?> type = target.getClass();
            if (registry.hasTypeHandler(type)) {
                return target;
            }
            Object enhanced = Enhancer.create(type, new EnhancedResultObjectProxyImpl(lazyLoader, aggressive));
            EnhancedResultObjectProxyImpl.copyInitialState(type, target, enhanced);
            return enhanced;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object o, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            try {
                String methodName = method.getName();
                ResultLoaderMap resultLoaderMap = this.lazyLoader;
                synchronized (resultLoaderMap) {
                    if (this.lazyLoader.size() > 0) {
                        String property;
                        if (this.aggressive || objectMethods.contains(methodName)) {
                            this.lazyLoader.loadAll();
                        } else if (PropertyNamer.isProperty(methodName) && this.lazyLoader.hasLoader(property = PropertyNamer.methodToProperty(methodName))) {
                            this.lazyLoader.load(property);
                        }
                    }
                }
                return methodProxy.invokeSuper(o, args);
            }
            catch (Throwable t) {
                throw ExceptionUtil.unwrapThrowable(t);
            }
        }

        private static void copyInitialState(Class type, Object target, Object enhanced) {
            for (Class parent = type; parent != null; parent = parent.getSuperclass()) {
                Field[] fields;
                for (Field field : fields = parent.getDeclaredFields()) {
                    try {
                        field.setAccessible(true);
                        field.set(enhanced, field.get(target));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

