/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder.xml;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.builder.xml.XMLMapperBuilder;
import org.apache.ibatis.builder.xml.XMLMapperEntityResolver;
import org.apache.ibatis.datasource.DataSourceFactory;
import org.apache.ibatis.executor.ErrorContext;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.Environment;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.parsing.XPathParser;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.reflection.MetaClass;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.apache.ibatis.session.AutoMappingBehavior;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.transaction.TransactionFactory;
import org.apache.ibatis.type.TypeHandler;
import org.xml.sax.EntityResolver;

public class XMLConfigBuilder
extends BaseBuilder {
    private boolean parsed;
    private XPathParser parser;
    private String environment;
    private Map<String, XNode> sqlFragments = new HashMap<String, XNode>();

    public XMLConfigBuilder(Reader reader) {
        this(reader, null, null);
    }

    public XMLConfigBuilder(Reader reader, String environment) {
        this(reader, environment, null);
    }

    public XMLConfigBuilder(Reader reader, String environment, Properties props) {
        super(new Configuration());
        ErrorContext.instance().resource("SQL Mapper Configuration");
        this.configuration.setVariables(props);
        this.parsed = false;
        this.environment = environment;
        this.parser = new XPathParser(reader, true, (EntityResolver)new XMLMapperEntityResolver(), props);
    }

    public Configuration parse() {
        if (this.parsed) {
            throw new BuilderException("Each MapperConfigParser can only be used once.");
        }
        this.parsed = true;
        this.parseConfiguration(this.parser.evalNode("/configuration"));
        return this.configuration;
    }

    private void parseConfiguration(XNode root) {
        try {
            this.typeAliasesElement(root.evalNode("typeAliases"));
            this.pluginElement(root.evalNode("plugins"));
            this.objectFactoryElement(root.evalNode("objectFactory"));
            this.objectWrapperFactoryElement(root.evalNode("objectWrapperFactory"));
            this.propertiesElement(root.evalNode("properties"));
            this.settingsElement(root.evalNode("settings"));
            this.environmentsElement(root.evalNode("environments"));
            this.typeHandlerElement(root.evalNode("typeHandlers"));
            this.mapperElement(root.evalNode("mappers"));
        }
        catch (Exception e) {
            throw new BuilderException("Error parsing SQL Mapper Configuration. Cause: " + e, e);
        }
    }

    private void typeAliasesElement(XNode parent) {
        if (parent != null) {
            for (XNode child : parent.getChildren()) {
                String alias = child.getStringAttribute("alias");
                String type = child.getStringAttribute("type");
                try {
                    Class clazz = Resources.classForName(type);
                    if (alias == null) {
                        this.typeAliasRegistry.registerAlias(clazz);
                        continue;
                    }
                    this.typeAliasRegistry.registerAlias(alias, clazz);
                }
                catch (ClassNotFoundException e) {
                    throw new BuilderException("Error registering typeAlias for '" + alias + "'. Cause: " + e, e);
                }
            }
        }
    }

    private void pluginElement(XNode parent) throws Exception {
        if (parent != null) {
            for (XNode child : parent.getChildren()) {
                String interceptor = child.getStringAttribute("interceptor");
                Properties properties = child.getChildrenAsProperties();
                Interceptor interceptorInstance = (Interceptor)this.resolveClass(interceptor).newInstance();
                interceptorInstance.setProperties(properties);
                this.configuration.addInterceptor(interceptorInstance);
            }
        }
    }

    private void objectFactoryElement(XNode context) throws Exception {
        if (context != null) {
            String type = context.getStringAttribute("type");
            Properties properties = context.getChildrenAsProperties();
            ObjectFactory factory = (ObjectFactory)this.resolveClass(type).newInstance();
            factory.setProperties(properties);
            this.configuration.setObjectFactory(factory);
        }
    }

    private void objectWrapperFactoryElement(XNode context) throws Exception {
        if (context != null) {
            String type = context.getStringAttribute("type");
            ObjectWrapperFactory factory = (ObjectWrapperFactory)this.resolveClass(type).newInstance();
            this.configuration.setObjectWrapperFactory(factory);
        }
    }

    private void propertiesElement(XNode context) throws Exception {
        if (context != null) {
            Properties defaults = context.getChildrenAsProperties();
            String resource = context.getStringAttribute("resource");
            String url = context.getStringAttribute("url");
            if (resource != null && url != null) {
                throw new BuilderException("The properties element cannot specify both a URL and a resource based property file reference.  Please specify one or the other.");
            }
            if (resource != null) {
                defaults.putAll((Map<?, ?>)Resources.getResourceAsProperties(resource));
            } else if (url != null) {
                defaults.putAll((Map<?, ?>)Resources.getUrlAsProperties(url));
            }
            Properties vars = this.configuration.getVariables();
            if (vars != null) {
                defaults.putAll((Map<?, ?>)vars);
            }
            this.parser.setVariables(defaults);
            this.configuration.setVariables(defaults);
        }
    }

    private void settingsElement(XNode context) throws Exception {
        if (context != null) {
            Properties props = context.getChildrenAsProperties();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                MetaClass metaConfig = MetaClass.forClass(Configuration.class);
                if (metaConfig.hasSetter((String)entry.getKey())) continue;
                throw new BuilderException("The setting " + entry.getKey() + " is not known.  Make sure you spelled it correctly (case sensitive).");
            }
            this.configuration.setAutoMappingBehavior(AutoMappingBehavior.valueOf(this.stringValueOf(props.getProperty("autoMappingBehavior"), "PARTIAL")));
            this.configuration.setCacheEnabled(this.booleanValueOf(props.getProperty("cacheEnabled"), true));
            this.configuration.setLazyLoadingEnabled(this.booleanValueOf(props.getProperty("lazyLoadingEnabled"), this.safeCglibCheck()));
            this.configuration.setAggressiveLazyLoading(this.booleanValueOf(props.getProperty("aggressiveLazyLoading"), true));
            this.configuration.setMultipleResultSetsEnabled(this.booleanValueOf(props.getProperty("multipleResultSetsEnabled"), true));
            this.configuration.setUseColumnLabel(this.booleanValueOf(props.getProperty("useColumnLabel"), true));
            this.configuration.setUseGeneratedKeys(this.booleanValueOf(props.getProperty("useGeneratedKeys"), false));
            this.configuration.setDefaultExecutorType(ExecutorType.valueOf(this.stringValueOf(props.getProperty("defaultExecutorType"), "SIMPLE")));
            this.configuration.setDefaultStatementTimeout(this.integerValueOf(props.getProperty("defaultStatementTimeout"), null));
        }
    }

    private boolean safeCglibCheck() {
        try {
            return Resources.classForName("net.sf.cglib.proxy.Enhancer") != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void environmentsElement(XNode context) throws Exception {
        if (context != null) {
            if (this.environment == null) {
                this.environment = context.getStringAttribute("default");
            }
            for (XNode child : context.getChildren()) {
                String id = child.getStringAttribute("id");
                if (!this.isSpecifiedEnvironment(id)) continue;
                TransactionFactory txFactory = this.transactionManagerElement(child.evalNode("transactionManager"));
                DataSourceFactory dsFactory = this.dataSourceElement(child.evalNode("dataSource"));
                Environment.Builder environmentBuilder = new Environment.Builder(id, txFactory, dsFactory.getDataSource());
                this.configuration.setEnvironment(environmentBuilder.build());
            }
        }
    }

    private TransactionFactory transactionManagerElement(XNode context) throws Exception {
        if (context != null) {
            String type = context.getStringAttribute("type");
            Properties props = context.getChildrenAsProperties();
            TransactionFactory factory = (TransactionFactory)this.resolveClass(type).newInstance();
            factory.setProperties(props);
            return factory;
        }
        throw new BuilderException("Environment declaration requires a TransactionFactory.");
    }

    private DataSourceFactory dataSourceElement(XNode context) throws Exception {
        if (context != null) {
            String type = context.getStringAttribute("type");
            Properties props = context.getChildrenAsProperties();
            DataSourceFactory factory = (DataSourceFactory)this.resolveClass(type).newInstance();
            factory.setProperties(props);
            return factory;
        }
        throw new BuilderException("Environment declaration requires a DataSourceFactory.");
    }

    private void typeHandlerElement(XNode parent) throws Exception {
        if (parent != null) {
            for (XNode child : parent.getChildren()) {
                String javaType = child.getStringAttribute("javaType");
                String jdbcType = child.getStringAttribute("jdbcType");
                String handler = child.getStringAttribute("handler");
                Class javaTypeClass = this.resolveClass(javaType);
                TypeHandler typeHandlerInstance = (TypeHandler)this.resolveClass(handler).newInstance();
                if (jdbcType == null) {
                    this.typeHandlerRegistry.register(javaTypeClass, typeHandlerInstance);
                    continue;
                }
                this.typeHandlerRegistry.register(javaTypeClass, this.resolveJdbcType(jdbcType), typeHandlerInstance);
            }
        }
    }

    private void mapperElement(XNode parent) throws Exception {
        if (parent != null) {
            for (XNode child : parent.getChildren()) {
                XMLMapperBuilder mapperParser;
                Reader reader;
                String resource = child.getStringAttribute("resource");
                String url = child.getStringAttribute("url");
                if (resource != null && url == null) {
                    ErrorContext.instance().resource(resource);
                    reader = Resources.getResourceAsReader(resource);
                    mapperParser = new XMLMapperBuilder(reader, this.configuration, resource, this.sqlFragments);
                    mapperParser.parse();
                    continue;
                }
                if (url != null && resource == null) {
                    ErrorContext.instance().resource(url);
                    reader = Resources.getUrlAsReader(url);
                    mapperParser = new XMLMapperBuilder(reader, this.configuration, url, this.sqlFragments);
                    mapperParser.parse();
                    continue;
                }
                throw new BuilderException("A mapper element may only specify a url or resource, but not both.");
            }
        }
    }

    private boolean isSpecifiedEnvironment(String id) {
        if (this.environment == null) {
            throw new BuilderException("No environment specified.");
        }
        if (id == null) {
            throw new BuilderException("Environment requires an id attribute.");
        }
        return this.environment.equals(id);
    }
}

