/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.EmailUtils;
import org.apache.commons.mail.MultiPartEmail;

public class HtmlEmail
extends MultiPartEmail {
    public static final int CID_LENGTH = 10;
    private static final String HTML_MESSAGE_START = "<html><body><pre>";
    private static final String HTML_MESSAGE_END = "</pre></body></html>";
    protected String text;
    protected String html;
    @Deprecated
    protected List<InlineImage> inlineImages;
    protected Map<String, InlineImage> inlineEmbeds = new HashMap<String, InlineImage>();

    public HtmlEmail setTextMsg(String aText) throws EmailException {
        if (EmailUtils.isEmpty(aText)) {
            throw new EmailException("Invalid message supplied");
        }
        this.text = aText;
        return this;
    }

    public HtmlEmail setHtmlMsg(String aHtml) throws EmailException {
        if (EmailUtils.isEmpty(aHtml)) {
            throw new EmailException("Invalid message supplied");
        }
        this.html = aHtml;
        return this;
    }

    public Email setMsg(String msg) throws EmailException {
        if (EmailUtils.isEmpty(msg)) {
            throw new EmailException("Invalid message supplied");
        }
        this.setTextMsg(msg);
        StringBuffer htmlMsgBuf = new StringBuffer(msg.length() + HTML_MESSAGE_START.length() + HTML_MESSAGE_END.length());
        htmlMsgBuf.append(HTML_MESSAGE_START).append(msg).append(HTML_MESSAGE_END);
        this.setHtmlMsg(htmlMsgBuf.toString());
        return this;
    }

    public String embed(String urlString, String name) throws EmailException {
        try {
            return this.embed(new URL(urlString), name);
        }
        catch (MalformedURLException e) {
            throw new EmailException("Invalid URL", e);
        }
    }

    public String embed(URL url, String name) throws EmailException {
        if (EmailUtils.isEmpty(name)) {
            throw new EmailException("name cannot be null or empty");
        }
        if (this.inlineEmbeds.containsKey(name)) {
            InlineImage ii = this.inlineEmbeds.get(name);
            URLDataSource urlDataSource = (URLDataSource)ii.getDataSource();
            if (url.toExternalForm().equals(urlDataSource.getURL().toExternalForm())) {
                return ii.getCid();
            }
            throw new EmailException("embedded name '" + name + "' is already bound to URL " + urlDataSource.getURL() + "; existing names cannot be rebound");
        }
        InputStream is = null;
        try {
            is = url.openStream();
        }
        catch (IOException e) {
            throw new EmailException("Invalid URL", e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ioe) {}
        }
        return this.embed(new URLDataSource(url), name);
    }

    public String embed(File file) throws EmailException {
        String cid = EmailUtils.randomAlphabetic(10).toLowerCase(Locale.ENGLISH);
        return this.embed(file, cid);
    }

    public String embed(File file, String cid) throws EmailException {
        if (EmailUtils.isEmpty(file.getName())) {
            throw new EmailException("file name cannot be null or empty");
        }
        String filePath = null;
        try {
            filePath = file.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new EmailException("couldn't get canonical path for " + file.getName(), ioe);
        }
        if (this.inlineEmbeds.containsKey(file.getName())) {
            InlineImage ii = this.inlineEmbeds.get(file.getName());
            FileDataSource fileDataSource = (FileDataSource)ii.getDataSource();
            String existingFilePath = null;
            try {
                existingFilePath = fileDataSource.getFile().getCanonicalPath();
            }
            catch (IOException ioe) {
                throw new EmailException("couldn't get canonical path for file " + fileDataSource.getFile().getName() + "which has already been embedded", ioe);
            }
            if (filePath.equals(existingFilePath)) {
                return ii.getCid();
            }
            throw new EmailException("embedded name '" + file.getName() + "' is already bound to file " + existingFilePath + "; existing names cannot be rebound");
        }
        if (!file.exists()) {
            throw new EmailException("file " + filePath + " doesn't exist");
        }
        if (!file.isFile()) {
            throw new EmailException("file " + filePath + " isn't a normal file");
        }
        if (!file.canRead()) {
            throw new EmailException("file " + filePath + " isn't readable");
        }
        return this.embed(new FileDataSource(file), file.getName(), cid);
    }

    public String embed(DataSource dataSource, String name) throws EmailException {
        if (this.inlineEmbeds.containsKey(name)) {
            InlineImage ii = this.inlineEmbeds.get(name);
            if (dataSource.equals(ii.getDataSource())) {
                return ii.getCid();
            }
            throw new EmailException("embedded DataSource '" + name + "' is already bound to name " + ii.getDataSource().toString() + "; existing names cannot be rebound");
        }
        String cid = EmailUtils.randomAlphabetic(10).toLowerCase();
        return this.embed(dataSource, name, cid);
    }

    public String embed(DataSource dataSource, String name, String cid) throws EmailException {
        if (EmailUtils.isEmpty(name)) {
            throw new EmailException("name cannot be null or empty");
        }
        MimeBodyPart mbp = new MimeBodyPart();
        try {
            String encodedCid = EmailUtils.encodeUrl(cid);
            mbp.setDataHandler(new DataHandler(dataSource));
            mbp.setFileName(name);
            mbp.setDisposition("inline");
            mbp.setContentID("<" + encodedCid + ">");
            InlineImage ii = new InlineImage(encodedCid, dataSource, mbp);
            this.inlineEmbeds.put(name, ii);
            return encodedCid;
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
        catch (UnsupportedEncodingException uee) {
            throw new EmailException(uee);
        }
    }

    public void buildMimeMessage() throws EmailException {
        try {
            this.build();
        }
        catch (MessagingException me) {
            throw new EmailException(me);
        }
        super.buildMimeMessage();
    }

    private void build() throws MessagingException, EmailException {
        MimeMultipart rootContainer;
        MimeMultipart bodyEmbedsContainer = rootContainer = this.getContainer();
        MimeMultipart bodyContainer = rootContainer;
        MimeBodyPart msgHtml = null;
        MimeBodyPart msgText = null;
        rootContainer.setSubType("mixed");
        if (EmailUtils.isNotEmpty(this.html) && this.inlineEmbeds.size() > 0) {
            bodyContainer = bodyEmbedsContainer = new MimeMultipart("related");
            this.addPart(bodyEmbedsContainer, 0);
            if (EmailUtils.isNotEmpty(this.text)) {
                bodyContainer = new MimeMultipart("alternative");
                BodyPart bodyPart = this.createBodyPart();
                try {
                    bodyPart.setContent(bodyContainer);
                    bodyEmbedsContainer.addBodyPart(bodyPart, 0);
                }
                catch (MessagingException me) {
                    throw new EmailException(me);
                }
            }
        } else if (EmailUtils.isNotEmpty(this.text) && EmailUtils.isNotEmpty(this.html)) {
            if (this.inlineEmbeds.size() > 0 || this.isBoolHasAttachments()) {
                bodyContainer = new MimeMultipart("alternative");
                this.addPart(bodyContainer, 0);
            } else {
                rootContainer.setSubType("alternative");
            }
        }
        if (EmailUtils.isNotEmpty(this.html)) {
            msgHtml = new MimeBodyPart();
            bodyContainer.addBodyPart(msgHtml, 0);
            msgHtml.setText(this.html, this.charset, "html");
            String contentType = msgHtml.getContentType();
            if (contentType == null || !contentType.equals("text/html")) {
                if (EmailUtils.isNotEmpty(this.charset)) {
                    msgHtml.setContent(this.html, "text/html; charset=" + this.charset);
                } else {
                    msgHtml.setContent(this.html, "text/html");
                }
            }
            for (InlineImage image : this.inlineEmbeds.values()) {
                bodyEmbedsContainer.addBodyPart(image.getMbp());
            }
        }
        if (EmailUtils.isNotEmpty(this.text)) {
            msgText = new MimeBodyPart();
            bodyContainer.addBodyPart(msgText, 0);
            msgText.setText(this.text, this.charset);
        }
    }

    private static class InlineImage {
        private final String cid;
        private final DataSource dataSource;
        private final MimeBodyPart mbp;

        public InlineImage(String cid, DataSource dataSource, MimeBodyPart mbp) {
            this.cid = cid;
            this.dataSource = dataSource;
            this.mbp = mbp;
        }

        public String getCid() {
            return this.cid;
        }

        public DataSource getDataSource() {
            return this.dataSource;
        }

        public MimeBodyPart getMbp() {
            return this.mbp;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof InlineImage)) {
                return false;
            }
            InlineImage that = (InlineImage)obj;
            return this.cid.equals(that.cid);
        }

        public int hashCode() {
            return this.cid.hashCode();
        }
    }
}

