/*
 * Decompiled with CFR 0.152.
 */
package com.jk.xml;

import com.jk.exceptions.JKException;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class JKXmlHandler {
    private static JKXmlHandler instance = new JKXmlHandler();

    public static JKXmlHandler getInstance() {
        return instance;
    }

    public <T> T parse(InputStream in, Class<?> ... clas) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])clas);
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            Object t = jaxbUnmarshaller.unmarshal(in);
            return (T)t;
        }
        catch (JAXBException e) {
            throw new JKException(e);
        }
    }

    public void toXml(Object object, OutputStream out, Class<?> ... clas) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])clas);
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal(object, out);
        }
        catch (JAXBException e) {
            throw new JKException(e);
        }
    }

    public String toXml(Object obj) {
        return this.toXml(obj, obj.getClass());
    }

    public String toXml(Object obj, Class<?> ... clas) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.toXml(obj, out, clas);
        return out.toString();
    }
}

