/*
 * Decompiled with CFR 0.152.
 */
package com.jk.validation.builtin;

import com.jk.validation.Problems;
import com.jk.validation.Validator;
import com.jk.validation.builtin.EmailAddressValidator;
import com.jk.validation.builtin.ValidHostNameOrIPValidator;
import com.jk.validation.builtin.ValidationBundle;
import java.net.MalformedURLException;
import java.net.URL;

class UrlValidator
implements Validator<String> {
    UrlValidator() {
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        try {
            URL url = new URL(model);
            String host = url.getHost();
            if (!"".equals(host)) {
                return new ValidHostNameOrIPValidator(true).validate(problems, compName, host);
            }
            String protocol = url.getProtocol();
            if ("mailto".equals(protocol)) {
                String emailAddress = url.toString().substring("mailto:".length());
                emailAddress = emailAddress == null ? "" : emailAddress;
                return new EmailAddressValidator().validate(problems, compName, emailAddress);
            }
            return true;
        }
        catch (MalformedURLException e) {
            String problem = ValidationBundle.getMessage(UrlValidator.class, "URL_NOT_VALID", model);
            problems.add(problem);
            return false;
        }
    }
}

