/*
 * Decompiled with CFR 0.152.
 */
package com.jk.validation.builtin;

import com.jk.validation.Problems;
import com.jk.validation.Validator;
import com.jk.validation.builtin.ValidationBundle;

final class NumberRange
implements Validator<String> {
    private final Number max;
    private final Number min;

    NumberRange(Number min, Number max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        try {
            boolean result;
            if (model == null) {
                return false;
            }
            double val = Double.parseDouble(model);
            double minn = this.min.doubleValue();
            double maxx = this.max.doubleValue();
            boolean bl = result = val >= minn && val <= maxx;
            if (!result) {
                problems.add(ValidationBundle.getMessage(NumberRange.class, "VALUE_OUT_OF_RANGE", new Object[]{compName, model, this.min, this.max}));
            }
            return result;
        }
        catch (NumberFormatException e) {
            return true;
        }
    }
}

