/*
 * Decompiled with CFR 0.152.
 */
package com.jk.validation.builtin;

import com.jk.validation.Problems;
import com.jk.validation.Validator;
import com.jk.validation.builtin.ValidationBundle;

class NonNegativeNumberValidator
implements Validator<String> {
    NonNegativeNumberValidator() {
    }

    @Override
    public boolean validate(Problems problems, String compName, String text) {
        try {
            double d = Double.parseDouble(text);
            if (d < 0.0) {
                String problem = ValidationBundle.getMessage(NonNegativeNumberValidator.class, "ERR_NEGATIVE_NUMBER", compName);
                problems.add(problem);
                return false;
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return true;
    }
}

