/*
 * Decompiled with CFR 0.152.
 */
package com.jk.validation.builtin;

import com.jk.validation.Problems;
import com.jk.validation.Validator;
import com.jk.validation.builtin.ValidationBundle;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

final class IsANumberValidator
implements Validator<String> {
    private final Locale locale;

    IsANumberValidator() {
        this(null);
    }

    IsANumberValidator(Locale l) {
        this.locale = l;
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        ParsePosition p = new ParsePosition(0);
        try {
            NumberFormat.getNumberInstance(this.locale == null ? Locale.getDefault() : this.locale).parse(model, p);
            if (model.length() != p.getIndex() || p.getErrorIndex() != -1) {
                problems.add(ValidationBundle.getMessage(IsANumberValidator.class, "NOT_A_NUMBER", model, compName));
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            problems.add(ValidationBundle.getMessage(IsANumberValidator.class, "NOT_A_NUMBER", model, compName));
            return false;
        }
        return true;
    }
}

