/*
 * Decompiled with CFR 0.152.
 */
package com.jk.validation.builtin;

import com.jk.validation.Problems;
import com.jk.validation.Validator;
import com.jk.validation.builtin.ValidationBundle;

final class IpAddressValidator
implements Validator<String> {
    IpAddressValidator() {
    }

    @Override
    public boolean validate(Problems problems, String compName, String s) {
        if (s.startsWith(".") || s.endsWith(".")) {
            problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "HOST_STARTS_OR_ENDS_WITH_PERIOD", s));
            return false;
        }
        if (s.indexOf(" ") >= 0 || s.indexOf("\t") >= 0) {
            problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "IP_ADDRESS_CONTAINS_WHITESPACE", compName, s));
            return false;
        }
        String[] parts = s.split("\\.");
        if (parts.length > 4) {
            problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "TOO_MANY_LABELS", s));
            return false;
        }
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i == parts.length - 1 && part.indexOf(":") > 0) {
                String[] pts = part.split(":");
                try {
                    int addr = Integer.parseInt(pts[0]);
                    if (addr < 0) {
                        problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "ADDR_PART_NEGATIVE", pts[1]));
                        return false;
                    }
                    if (addr > 256) {
                        problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "ADDR_PART_HIGH", pts[1]));
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "ADDR_PART_BAD", pts.length >= 2 ? pts[1] : "''"));
                    return false;
                }
                if (pts.length == 2 && pts[1].length() == 0) {
                    problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "INVALID_PORT", compName, ""));
                    return false;
                }
                if (pts.length <= 1) continue;
                try {
                    int port = Integer.parseInt(pts[1]);
                    if (port < 0) {
                        problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "NEGATIVE_PORT", pts[1]));
                        return false;
                    }
                    if (port < 65536) continue;
                    problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "PORT_TOO_HIGH", pts[1]));
                    return false;
                }
                catch (NumberFormatException e) {
                    problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "INVALID_PORT", compName, pts[1]));
                    return false;
                }
            }
            try {
                int addr = Integer.parseInt(part);
                if (addr < 0) {
                    problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "ADDR_PART_NEGATIVE", part));
                    return false;
                }
                if (addr <= 256) continue;
                problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "ADDR_PART_HIGH", part));
                return false;
            }
            catch (NumberFormatException e) {
                problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "ADDR_PART_BAD", part));
                return false;
            }
        }
        return true;
    }
}

