/*
 * Decompiled with CFR 0.152.
 */
package com.jk.validation.builtin;

import com.jk.validation.Problems;
import com.jk.validation.Validator;
import com.jk.validation.builtin.EncodableInCharsetValidator;
import com.jk.validation.builtin.IpAddressValidator;
import com.jk.validation.builtin.MayNotContainSpacesValidator;
import com.jk.validation.builtin.ValidationBundle;

final class HostNameValidator
implements Validator<String> {
    private final boolean allowPort;

    HostNameValidator(boolean allowPort) {
        this.allowPort = allowPort;
    }

    private boolean checkHostPart(String label, Problems problems, String compName) {
        boolean result = true;
        if (label.length() > 63) {
            problems.add(ValidationBundle.getMessage(HostNameValidator.class, "LABEL_TOO_LONG", label));
            result = false;
        }
        if (label.length() == 0) {
            problems.add(ValidationBundle.getMessage(HostNameValidator.class, "LABEL_EMPTY", compName, label));
        }
        if (result) {
            try {
                Integer.parseInt(label);
                problems.add(ValidationBundle.getMessage(HostNameValidator.class, "NUMBER_PART_IN_HOSTNAME", label));
                result = false;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (result && result && (result = new EncodableInCharsetValidator().validate(problems, compName, label))) {
                for (char c : label.toLowerCase().toCharArray()) {
                    if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-') continue;
                    problems.add(ValidationBundle.getMessage(HostNameValidator.class, "BAD_CHAR_IN_HOSTNAME", new String(new char[]{c})));
                    result = false;
                }
            }
        }
        return result;
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        if (model.length() == 0) {
            problems.add(ValidationBundle.getMessage(HostNameValidator.class, "INVALID_HOST_NAME", compName, model));
            return false;
        }
        if (model.startsWith(".") || model.endsWith(".")) {
            problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "HOST_STARTS_OR_ENDS_WITH_PERIOD", model));
            return false;
        }
        String[] parts = model.split("\\.");
        if (parts.length > 4) {
            problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "TOO_MANY_LABELS", model));
            return false;
        }
        if (!this.allowPort && model.contains(":")) {
            problems.add(ValidationBundle.getMessage(HostNameValidator.class, "MSG_PORT_NOT_ALLOWED", compName, model));
            return false;
        }
        boolean result = new MayNotContainSpacesValidator().validate(problems, compName, model);
        if (!result) {
            return false;
        }
        if (model.endsWith("-") || model.startsWith("-")) {
            problems.add(ValidationBundle.getMessage(HostNameValidator.class, "INVALID_HOST_NAME", compName, model));
            return false;
        }
        for (int i = 0; i < parts.length; ++i) {
            String label = parts[i];
            if (label.length() > 63) {
                problems.add(ValidationBundle.getMessage(HostNameValidator.class, "LABEL_TOO_LONG", label));
                return false;
            }
            if (i == parts.length - 1 && label.indexOf(":") > 0) {
                String[] labelAndPort = label.split(":");
                if (labelAndPort.length > 2) {
                    problems.add(ValidationBundle.getMessage(HostNameValidator.class, "INVALID_PORT", compName, label));
                    return false;
                }
                if (labelAndPort.length == 1) {
                    problems.add(ValidationBundle.getMessage(HostNameValidator.class, "INVALID_PORT", compName, "''"));
                    return false;
                }
                if (label.endsWith(":")) {
                    problems.add(ValidationBundle.getMessage(HostNameValidator.class, "TOO_MANY_COLONS", compName, label));
                    return false;
                }
                try {
                    int port = Integer.parseInt(labelAndPort[1]);
                    if (port < 0) {
                        problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "NEGATIVE_PORT", port));
                        return false;
                    }
                    if (port >= 65536) {
                        problems.add(ValidationBundle.getMessage(IpAddressValidator.class, "PORT_TOO_HIGH", port));
                        return false;
                    }
                }
                catch (NumberFormatException e) {
                    problems.add(ValidationBundle.getMessage(HostNameValidator.class, "INVALID_PORT", compName, labelAndPort[1]));
                    return false;
                }
                if (this.checkHostPart(labelAndPort[0], problems, compName)) continue;
                return false;
            }
            if (this.checkHostPart(label, problems, compName)) continue;
            return false;
        }
        return true;
    }
}

