/*
 * Decompiled with CFR 0.152.
 */
package com.jk.validation.builtin;

import com.jk.validation.Problems;
import com.jk.validation.Severity;
import com.jk.validation.Validator;
import com.jk.validation.builtin.ValidationBundle;
import java.io.File;

final class FileValidator
implements Validator<String> {
    private final Type type;

    FileValidator(Type type) {
        this.type = type;
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        boolean ok;
        String key;
        File file = new File(model);
        switch (this.type) {
            case MUST_EXIST: {
                key = "FILE_DOES_NOT_EXIST";
                ok = file.exists();
                break;
            }
            case MUST_BE_DIRECTORY: {
                key = "FILE_IS_NOT_A_DIRECTORY";
                ok = file.isDirectory();
                break;
            }
            case MUST_BE_FILE: {
                key = "FILE_IS_NOT_A_FILE";
                ok = file.isFile();
                break;
            }
            case MUST_NOT_EXIST: {
                key = "FILE_EXISTS";
                ok = !file.exists();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (!ok) {
            String problem = ValidationBundle.getMessage(FileValidator.class, key, file.getName());
            problems.add(problem, Severity.FATAL);
        }
        return ok;
    }

    static enum Type {
        MUST_EXIST,
        MUST_NOT_EXIST,
        MUST_BE_DIRECTORY,
        MUST_BE_FILE;

    }
}

