/*
 * Decompiled with CFR 0.152.
 */
package com.jk.validation.builtin;

import com.jk.validation.Problems;
import com.jk.validation.Validator;
import com.jk.validation.builtin.DisallowCharactersValidator;
import com.jk.validation.builtin.EmailAddressValidator;
import com.jk.validation.builtin.EmptyStringIllegalValidator;
import com.jk.validation.builtin.EncodableInCharsetValidator;
import com.jk.validation.builtin.FileValidator;
import com.jk.validation.builtin.FormatValidator;
import com.jk.validation.builtin.HostNameValidator;
import com.jk.validation.builtin.IllegalCharactersInFileNameValidator;
import com.jk.validation.builtin.IpAddressValidator;
import com.jk.validation.builtin.IsANumberValidator;
import com.jk.validation.builtin.IsAnIntegerValidator;
import com.jk.validation.builtin.MaximumLength;
import com.jk.validation.builtin.MayNotContainSpacesValidator;
import com.jk.validation.builtin.MayNotStartWithDigit;
import com.jk.validation.builtin.MinimumLength;
import com.jk.validation.builtin.NonNegativeNumberValidator;
import com.jk.validation.builtin.NotJavaIdentifierValidator;
import com.jk.validation.builtin.NumberRange;
import com.jk.validation.builtin.OrValidator;
import com.jk.validation.builtin.RegexpValidator;
import com.jk.validation.builtin.SplitStringValidator;
import com.jk.validation.builtin.TrimStringValidator;
import com.jk.validation.builtin.UrlValidator;
import com.jk.validation.builtin.ValidHexadecimalNumberValidator;
import com.jk.validation.builtin.ValidHostNameOrIPValidator;
import java.text.Format;
import java.util.Locale;

public enum FSValidators implements Validator
{
    REQUIRE_NON_EMPTY_STRING,
    REQUIRE_VALID_FILENAME,
    REQUIRE_VALID_INTEGER,
    REQUIRE_NON_NEGATIVE_NUMBER,
    REQUIRE_VALID_NUMBER,
    REQUIRE_JAVA_IDENTIFIER,
    VALID_HEXADECIMAL_NUMBER,
    NO_WHITESPACE,
    FILE_MUST_EXIST,
    FILE_MUST_BE_FILE,
    FILE_MUST_BE_DIRECTORY,
    URL_MUST_BE_VALID,
    IP_ADDRESS,
    HOST_NAME,
    HOST_NAME_OR_IP_ADDRESS,
    MAY_NOT_START_WITH_DIGIT,
    EMAIL_ADDRESS,
    CHARACTER_SET_NAME,
    JAVA_PACKAGE_NAME,
    FILE_MUST_NOT_EXIST;


    public static Validator<String> disallowChars(char[] chars, boolean trim) {
        DisallowCharactersValidator v = new DisallowCharactersValidator(chars);
        return trim ? new TrimStringValidator(v) : v;
    }

    public static Validator<String> encodableInCharset(String charsetName) {
        return new EncodableInCharsetValidator(charsetName);
    }

    public static Validator<String> forFormat(Format fmt) {
        return new FormatValidator(fmt);
    }

    public static Validator<String> maxLength(int length) {
        return new MaximumLength(length);
    }

    public static Validator<String> merge(boolean trim, Validator<String> ... validators) {
        return trim ? new TrimStringValidator(FSValidators.merge(validators)) : FSValidators.merge(validators);
    }

    public static <T> Validator<T> merge(Validator<T> ... validators) {
        if (validators == null) {
            throw new NullPointerException();
        }
        if (validators.length == 1) {
            return validators[0];
        }
        return new OrValidator<T>(validators);
    }

    public static Validator<String> minLength(int length) {
        return new MinimumLength(length);
    }

    public static Validator<String> numberRange(Number min, Number max) {
        return new NumberRange(min, max);
    }

    public static Validator<String> regexp(String regexp, String message, boolean acceptPartialMatches) {
        return new RegexpValidator(regexp, message, acceptPartialMatches);
    }

    public static Validator<String> splitString(String regexp, Validator<String> other) {
        return new SplitStringValidator(regexp, other);
    }

    public static Validator<String> trimString(Validator<String> ... others) {
        if (others == null) {
            throw new NullPointerException("Null validators passed");
        }
        if (others.length == 1) {
            return new TrimStringValidator(others[0]);
        }
        return new TrimStringValidator(new OrValidator<String>(others));
    }

    public static Validator<String> validNumber() {
        return new IsANumberValidator(Locale.US);
    }

    public Validator forString(boolean trim) {
        Validator<String> result2;
        switch (this) {
            case REQUIRE_JAVA_IDENTIFIER: {
                result2 = new NotJavaIdentifierValidator();
                break;
            }
            case REQUIRE_NON_EMPTY_STRING: {
                result2 = new EmptyStringIllegalValidator();
                break;
            }
            case REQUIRE_NON_NEGATIVE_NUMBER: {
                result2 = new NonNegativeNumberValidator();
                break;
            }
            case REQUIRE_VALID_FILENAME: {
                result2 = new IllegalCharactersInFileNameValidator();
                break;
            }
            case REQUIRE_VALID_INTEGER: {
                result2 = new IsAnIntegerValidator();
                break;
            }
            case REQUIRE_VALID_NUMBER: {
                result2 = new IsANumberValidator();
                break;
            }
            case VALID_HEXADECIMAL_NUMBER: {
                result2 = new ValidHexadecimalNumberValidator();
                break;
            }
            case NO_WHITESPACE: {
                result2 = new MayNotContainSpacesValidator();
                break;
            }
            case FILE_MUST_BE_DIRECTORY: {
                result2 = new FileValidator(FileValidator.Type.MUST_BE_DIRECTORY);
                break;
            }
            case FILE_MUST_BE_FILE: {
                result2 = new FileValidator(FileValidator.Type.MUST_BE_FILE);
                break;
            }
            case FILE_MUST_EXIST: {
                result2 = new FileValidator(FileValidator.Type.MUST_EXIST);
                break;
            }
            case FILE_MUST_NOT_EXIST: {
                result2 = new FileValidator(FileValidator.Type.MUST_NOT_EXIST);
                break;
            }
            case URL_MUST_BE_VALID: {
                result2 = new UrlValidator();
                break;
            }
            case IP_ADDRESS: {
                result2 = new IpAddressValidator();
                break;
            }
            case HOST_NAME: {
                result2 = new HostNameValidator(true);
                break;
            }
            case HOST_NAME_OR_IP_ADDRESS: {
                result2 = new ValidHostNameOrIPValidator();
                break;
            }
            case MAY_NOT_START_WITH_DIGIT: {
                result2 = new MayNotStartWithDigit();
                break;
            }
            case EMAIL_ADDRESS: {
                EmailAddressValidator result2 = new EmailAddressValidator();
                return result2;
            }
            case JAVA_PACKAGE_NAME: {
                Validator<String> result2 = FSValidators.splitString("\\.", FSValidators.merge(false, REQUIRE_JAVA_IDENTIFIER));
                return result2;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (trim) {
            return new TrimStringValidator(result2);
        }
        return result2;
    }

    public Validator<String> trim() {
        return this.forString(true);
    }

    public boolean validate(Problems problems, String compName, Object model) {
        return this.forString(false).validate(problems, compName, model);
    }
}

