/*
 * Decompiled with CFR 0.152.
 */
package com.jk.validation.builtin;

import com.jk.validation.Problems;
import com.jk.validation.Validator;
import com.jk.validation.builtin.ValidationBundle;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

final class EncodableInCharsetValidator
implements Validator<String> {
    private final String charsetName;

    EncodableInCharsetValidator() {
        this(Charset.defaultCharset().name());
    }

    EncodableInCharsetValidator(String charsetName) {
        this.charsetName = charsetName;
        Charset.forName(charsetName);
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        char[] c = model.toCharArray();
        boolean result = true;
        for (char element : c) {
            String curr = new String(new char[]{element});
            try {
                String nue = new String(curr.getBytes(this.charsetName));
                boolean bl = result = element == nue.charAt(0);
                if (result) continue;
                problems.add(ValidationBundle.getMessage(EncodableInCharsetValidator.class, "INVALID_CHARACTER", compName, curr, this.charsetName));
                break;
            }
            catch (UnsupportedEncodingException ex) {
                throw new AssertionError((Object)ex);
            }
        }
        return result;
    }
}

