/*
 * Decompiled with CFR 0.152.
 */
package com.jk.validation.builtin;

import com.jk.validation.Problem;
import com.jk.validation.Problems;
import com.jk.validation.Severity;
import com.jk.validation.Validator;
import com.jk.validation.builtin.EncodableInCharsetValidator;
import com.jk.validation.builtin.MayNotContainSpacesValidator;
import com.jk.validation.builtin.ValidHostNameOrIPValidator;
import com.jk.validation.builtin.ValidationBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class EmailAddressValidator
implements Validator<String> {
    static final Pattern ADDRESS_PATTERN = Pattern.compile("(.*?)<(.*)>$");
    private final ValidHostNameOrIPValidator hv = new ValidHostNameOrIPValidator(false);

    EmailAddressValidator() {
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        String address;
        Matcher m = ADDRESS_PATTERN.matcher(model);
        String realName = null;
        if (m.lookingAt()) {
            if (m.groupCount() == 2) {
                address = m.group(2);
                realName = m.group(1);
            } else {
                address = m.group(1);
            }
        } else {
            address = model;
        }
        return this.validate(realName, address, problems, compName);
    }

    private boolean validate(String realName, String address, Problems problems, String compName) {
        boolean result;
        String[] nameAndHost = address.split("@");
        if (nameAndHost.length == 1 && nameAndHost[0].contains("@")) {
            problems.add(ValidationBundle.getMessage(EmailAddressValidator.class, "EMAIL_MISSING_HOST", compName, nameAndHost[0]));
            return false;
        }
        if (nameAndHost.length > 2) {
            problems.add(ValidationBundle.getMessage(EmailAddressValidator.class, "EMAIL_HAS_>1_@", compName, address));
            return false;
        }
        String name = nameAndHost[0];
        if (name.length() == 0) {
            problems.add(ValidationBundle.getMessage(EmailAddressValidator.class, "EMAIL_MISSING_NAME", compName, name));
            return false;
        }
        if (name.length() > 64) {
            problems.add(new Problem(ValidationBundle.getMessage(EmailAddressValidator.class, "ADDRESS_MAY_BE_TOO_LONG", compName, name), Severity.WARNING));
        }
        String host = nameAndHost.length >= 2 ? nameAndHost[1] : null;
        boolean bl = result = host != null;
        if (result) {
            Validator<String> v;
            result = this.hv.validate(problems, compName, host);
            if (result) {
                v = new MayNotContainSpacesValidator();
                result = ((MayNotContainSpacesValidator)v).validate(problems, compName, name);
            }
            v = new EncodableInCharsetValidator("US-ASCII");
            if (result) {
                result = v.validate(problems, compName, address);
            }
        } else {
            problems.add(ValidationBundle.getMessage(EmailAddressValidator.class, "EMAIL_MISSING_HOST", compName, nameAndHost[0]));
        }
        return result;
    }

    private boolean validate(String realName, String name, String host, Problems problems, String compName) {
        return false;
    }
}

