/*
 * Decompiled with CFR 0.152.
 */
package com.jk.validation.builtin;

import com.jk.validation.Problems;
import com.jk.validation.Validator;
import com.jk.validation.builtin.ValidationBundle;

final class DisallowCharactersValidator
implements Validator<String> {
    private final char[] chars;

    public DisallowCharactersValidator(char[] chars) {
        this.chars = chars;
    }

    private String asString() {
        return "'" + new String(this.chars) + "' ";
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        for (char c : this.chars) {
            for (char cc : model.toCharArray()) {
                if (cc != c) continue;
                problems.add(ValidationBundle.getMessage(DisallowCharactersValidator.class, "DISALLOWED_CHARS", this.asString(), compName));
                return false;
            }
        }
        return true;
    }
}

