/*
 * Decompiled with CFR 0.152.
 */
package com.jk.validation.builtin;

import com.jk.validation.Problems;
import com.jk.validation.Validator;
import com.jk.validation.builtin.ValidationBundle;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;

final class CharsetValidator
implements Validator<String> {
    CharsetValidator() {
    }

    @Override
    public boolean validate(Problems problems, String compName, String model) {
        IllegalArgumentException e = null;
        try {
            Charset.forName(model);
        }
        catch (IllegalCharsetNameException badName) {
            problems.add(ValidationBundle.getMessage(CharsetValidator.class, "ILLEGAL_CHARSET_NAME", compName, model));
            e = badName;
        }
        catch (UnsupportedCharsetException unsup) {
            problems.add(ValidationBundle.getMessage(CharsetValidator.class, "UNSUPPORTED_CHARSET_NAME", compName, model));
            e = unsup;
        }
        return e == null;
    }
}

