/*
 * Decompiled with CFR 0.152.
 */
package com.jk.validation;

import com.jk.validation.Problem;
import com.jk.validation.Severity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Problems {
    private final List<Problem> problems = new ArrayList<Problem>();
    private boolean hasFatal;

    public final void add(Problem problem) {
        this.problems.add(problem);
    }

    public final void add(String problem) {
        this.add(problem, Severity.FATAL);
    }

    public final void add(String problem, Severity severity) {
        this.problems.add(new Problem(problem, severity));
        this.hasFatal |= severity == Severity.FATAL;
    }

    public final Problem getLeadProblem() {
        Collections.sort(this.problems);
        return this.problems.isEmpty() ? null : this.problems.get(this.problems.size() - 1);
    }

    public List<Problem> getProblemsList() {
        return this.problems;
    }

    public final boolean hasFatal() {
        return this.hasFatal;
    }

    public final boolean isEmpty() {
        return this.problems.isEmpty();
    }

    public final void putAll(Problems problems) {
        if (problems == this) {
            throw new IllegalArgumentException("putAll to self");
        }
        this.problems.addAll(problems.problems);
    }

    public String toMutilLineString() {
        String newLine = System.getProperty("line.separator");
        StringBuffer problemStr = new StringBuffer();
        for (Problem problem : this.problems) {
            problemStr.append(problem.getMessage() + newLine);
        }
        return problemStr.toString();
    }

    public String toString() {
        return this.problems.toString();
    }
}

