/*
 * Decompiled with CFR 0.152.
 */
package com.jk.validation;

import com.jk.validation.Severity;

public final class Problem
implements Comparable<Problem> {
    private final String message;
    private final Severity severity;

    public Problem(String message, Severity severity) {
        if (message == null) {
            throw new NullPointerException("Null message");
        }
        if (severity == null) {
            throw new NullPointerException("Null kind");
        }
        this.message = message;
        this.severity = severity;
    }

    @Override
    public int compareTo(Problem o) {
        int ix = this.severity.ordinal();
        int oid = o.severity.ordinal();
        return ix - oid;
    }

    public boolean equals(Object o) {
        boolean result;
        if (o == this) {
            return true;
        }
        boolean bl = result = o != null && o.getClass() == Problem.class;
        if (result) {
            Problem p = (Problem)o;
            result = p.severity == this.severity && p.getMessage().equals(this.getMessage());
        }
        return result;
    }

    public String getMessage() {
        return this.message;
    }

    public int hashCode() {
        return this.message.hashCode() * (this.severity.hashCode() + 1);
    }

    public boolean isFatal() {
        return this.severity == Severity.FATAL;
    }

    public boolean isWorseThan(Problem other) {
        return other == null ? true : this.compareTo(other) > 0;
    }

    public Severity severity() {
        return this.severity;
    }

    public String toString() {
        return this.getMessage() + "(" + (Object)((Object)this.severity()) + ")";
    }
}

