/*
 * Decompiled with CFR 0.152.
 */
package com.jk.util.model.table;

import com.jk.util.JKConversionUtil;
import com.jk.util.model.table.JKTableColumn;
import com.jk.util.model.table.JKTableColumnValue;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class JKTableRecord {
    Vector<JKTableColumnValue> columnsValues = new Vector();
    RecordStatus status;

    public void addEmptyValue(JKTableColumn col) {
        JKTableColumnValue value = new JKTableColumnValue(col);
        this.columnsValues.add(value);
    }

    public void addEmptyValues(Vector<JKTableColumn> tableColumns) {
        for (JKTableColumn col : tableColumns) {
            JKTableColumnValue value = new JKTableColumnValue(col);
            this.columnsValues.add(value);
        }
    }

    public JKTableColumn getColumn(int index) {
        return this.columnsValues.get(index).getTableColumn();
    }

    public int getColumnIndex(String name) {
        for (int i = 0; i < this.columnsValues.size(); ++i) {
            JKTableColumnValue value = this.columnsValues.get(i);
            if (!value.getTableColumn().getName().toLowerCase().equals(name.toLowerCase())) continue;
            return i;
        }
        return -1;
    }

    public Vector<JKTableColumnValue> getColumnsValues() {
        return this.columnsValues;
    }

    public Object getColumnValue(int col) {
        return this.columnsValues.get(col).getValue();
    }

    public Object getColumnValue(String name) {
        return this.getColumnValue(this.getColumnIndex(name));
    }

    public Date getColumnValueAsDate(int colIndex) {
        return JKConversionUtil.toDate(this.getColumnValue(colIndex));
    }

    public Date getColumnValueAsDate(String colName) {
        return this.getColumnValueAsDate(this.getColumnIndex(colName));
    }

    public double getColumnValueAsDouble(int col) {
        Object value = this.getColumnValue(col);
        if (value == null) {
            return 0.0;
        }
        return new Double(value.toString());
    }

    public Double getColumnValueAsDouble(int col, double defaultValue) {
        Double value = this.getColumnValueAsDouble(col);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public double getColumnValueAsDouble(String colName) {
        return this.getColumnValueAsDouble(this.getColumnIndex(colName));
    }

    public Float getColumnValueAsFloat(int col) {
        Object value = this.getColumnValue(col);
        if (value == null) {
            return null;
        }
        return new Float(value.toString());
    }

    public int getColumnValueAsInteger(int col) {
        return (int)this.getColumnValueAsDouble(col);
    }

    public int getColumnValueAsInteger(String colName) {
        return this.getColumnValueAsInteger(this.getColumnIndex(colName));
    }

    public Object getFieldValue(String name) {
        return this.getColumnValue(name);
    }

    public RecordStatus getStatus() {
        return this.status;
    }

    public boolean isColumnEnabled(int col) {
        return this.columnsValues.get(col).isEnabled();
    }

    public boolean isModified() {
        return this.getStatus() == RecordStatus.MODIFIED;
    }

    public void setColumnEnabled(int col, boolean enable) {
        this.columnsValues.get(col).setEnabled(enable);
    }

    public void setColumnsValues(Vector<JKTableColumnValue> values) {
        this.columnsValues = values;
    }

    public void setColumnValue(int columnIndex, Object value) {
        this.columnsValues.get(columnIndex).setValue(value);
    }

    public void setColumnValue(String colName, Object value) {
        this.setColumnValue(this.getColumnIndex(colName), value);
    }

    public void setFieldValue(String name, Object value) {
        this.setColumnValue(name, value);
    }

    public void setStatus(RecordStatus status) {
        this.status = status;
    }

    public Hashtable<String, Object> toHash() {
        Hashtable<String, Object> values = new Hashtable<String, Object>();
        for (int i = 0; i < this.columnsValues.size(); ++i) {
            JKTableColumnValue value = this.columnsValues.get(i);
            values.put(this.getColumn(i).getName(), value);
        }
        return values;
    }

    public Vector<Object> toValuesVector() {
        Vector<Object> values = new Vector<Object>();
        for (JKTableColumnValue value : this.columnsValues) {
            values.add(value);
        }
        return values;
    }

    public static enum RecordStatus {
        NEW,
        LATEST,
        MODIFIED,
        DELETED;

    }
}

