/*
 * Decompiled with CFR 0.152.
 */
package com.jk.util.model.table;

import com.jk.util.JKNumbersUtil;
import com.jk.util.model.table.JKTableColumn;
import com.jk.util.model.table.JKTableRecord;
import java.text.Format;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class JKTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -6003811835691538215L;
    private final Vector<JKTableColumn> tableColumns = new Vector();
    private final Vector<JKTableRecord> records = new Vector();
    private final ColumnVisiblityManagar visibilityManager = new ColumnVisiblityManagar(this.tableColumns);
    private final Vector<JKTableRecord> deletedRecords = new Vector();
    boolean modified;
    boolean allowDelete;

    public void addJKTableColumn(JKTableColumn col) {
        col.setIndex(this.tableColumns.size());
        this.tableColumns.add(col);
        this.visibilityManager.refreshVisibility();
        this.fireTableStructureChanged();
    }

    public JKTableRecord addRecord() {
        JKTableRecord record = this.createEmptyRecord();
        this.addRecord(record);
        return record;
    }

    public void addRecord(JKTableRecord record) {
        this.geteRecords().add(record);
        this.fireTableRowsInserted(this.getRowCount() - 1, this.getRowCount() - 1);
    }

    public void clearRecords() {
        this.records.clear();
        this.fireTableDataChanged();
    }

    protected JKTableRecord createEmptyRecord() {
        JKTableRecord record = new JKTableRecord();
        record.addEmptyValues(this.tableColumns);
        record.setStatus(JKTableRecord.RecordStatus.NEW);
        return record;
    }

    public JKTableRecord deleteRow(int selectedRow) {
        JKTableRecord removed = this.removeRecord(selectedRow);
        removed.setStatus(JKTableRecord.RecordStatus.DELETED);
        if (removed != null) {
            this.deletedRecords.add(removed);
        }
        this.fireTableRowsDeleted(selectedRow, selectedRow);
        return removed;
    }

    public void deleteRows(int[] rows) {
        for (int i = rows.length - 1; i >= 0; --i) {
            this.deleteRow(rows[i]);
        }
    }

    public void fireTableColumnDataChanged(int col) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.fireTableCellUpdated(i, col);
        }
    }

    public int getActualColumnCount() {
        return this.tableColumns.size();
    }

    public int getActualColumnIndexFromVisible(int visibleIndex) {
        return this.getTableColumn(visibleIndex, true).getIndex();
    }

    public String getActualColumnName(int index) {
        return this.getTableColumn(index).getName();
    }

    public TableCellEditor getCellEditor(int column) {
        return this.getTableColumn(column).getEditor();
    }

    public TableCellRenderer getCellRenderer(int column) {
        return this.getTableColumn(column).getRenderer();
    }

    public Class getColumnClass(int columnIndex) {
        return this.getTableColumn(columnIndex).getColumnClass();
    }

    @Override
    public int getColumnCount() {
        return this.visibilityManager.getVisibleColumnCount();
    }

    @Override
    public String getColumnName(int visibleColumnIndex) {
        return this.getTableColumn(visibleColumnIndex).getHumanName();
    }

    public int getColumnType(int col) {
        return this.getTableColumn(col).getColumnType();
    }

    public int getColunmIndex(String name) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getActualColumnName(i).trim().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public int getColunmIndexByName(String colName) {
        for (JKTableColumn col : this.tableColumns) {
            if (!col.getName().equalsIgnoreCase(colName)) continue;
            return col.getVisibleIndex();
        }
        return -1;
    }

    public double getColunmSum(int col) {
        double sum = 0.0;
        for (int i = 0; i < this.getRowCount(); ++i) {
            double number = this.getValueAtAsDouble(i, col);
            sum = JKNumbersUtil.addAmounts(sum, number);
        }
        return sum;
    }

    public Vector<JKTableRecord> getDeletedRecords() {
        return this.deletedRecords;
    }

    public Vector<Vector> getDeletedRecordsAsDataVector() {
        Vector<Vector> data = new Vector<Vector>();
        for (JKTableRecord rec : this.deletedRecords) {
            data.add(rec.toValuesVector());
        }
        return data;
    }

    private Vector<JKTableRecord> geteRecords() {
        return this.records;
    }

    public Format getFormatter(int col) {
        return this.getTableColumn(col).getFormatter();
    }

    public int getIntegerColunmSum(int col) {
        return (int)this.getColunmSum(col);
    }

    public int getPrefferedWidth(int column) {
        return this.getTableColumn(column).getPreferredWidth();
    }

    public JKTableRecord getRecord(int row) {
        if (row >= this.getRowCount()) {
            throw new IllegalStateException("Row : " + row + " is out of index");
        }
        return this.records.get(row);
    }

    public Vector<JKTableRecord> getRecords() {
        return this.records;
    }

    public Vector<Vector> getRecordsAsDataVector() {
        Vector<Vector> data = new Vector<Vector>();
        for (JKTableRecord rec : this.records) {
            data.add(rec.toValuesVector());
        }
        return data;
    }

    @Override
    public int getRowCount() {
        return this.tableColumns.size() == 0 || this.records == null ? 0 : this.records.size();
    }

    public JKTableColumn getTableColumn(int visibleColumnIndex) {
        return this.getTableColumn(visibleColumnIndex, true);
    }

    public JKTableColumn getTableColumn(int col, boolean visibleIndex) {
        int actualIndex = visibleIndex ? this.visibilityManager.getActualIndexFromVisibleIndex(col) : col;
        return this.tableColumns.get(actualIndex);
    }

    @Override
    public Object getValueAt(int row, int visibleColumnIndex) {
        int actualIndex = this.visibilityManager.getActualIndexFromVisibleIndex(visibleColumnIndex);
        return this.getRecords().get(row).getColumnValue(actualIndex);
    }

    public double getValueAtAsDouble(int row, int col) {
        Object valueAt = this.getValueAt(row, col);
        double number = 0.0;
        if (valueAt != null && !valueAt.toString().equals("")) {
            number = Double.parseDouble(valueAt.toString().trim());
        }
        return number;
    }

    public float getValueAtAsFloat(int row, int col) {
        Object valueAt = this.getValueAt(row, col);
        float number = 0.0f;
        if (valueAt != null && !valueAt.toString().equals("")) {
            number = Float.parseFloat(valueAt.toString().trim());
        }
        return number;
    }

    public int getValueAtAsInteger(int row, int col) {
        Object valueAt = this.getValueAt(row, col);
        int number = 0;
        if (valueAt != null && !valueAt.toString().equals("")) {
            number = Integer.parseInt(valueAt.toString().trim());
        }
        return number;
    }

    public int getVisibleColumnIndexFromActual(int actualIndex) {
        return this.getTableColumn(actualIndex, false).getVisibleIndex();
    }

    public void insertRecord(int selectedRow) {
        this.insertRecord(selectedRow, this.createEmptyRecord());
    }

    public void insertRecord(int row, JKTableRecord record) {
        this.records.insertElementAt(record, row);
        this.fireTableRowsInserted(row, row);
    }

    public boolean isAllDataValid() {
        for (JKTableColumn col : this.tableColumns) {
            Object colValue;
            int lastRow = this.getRowCount() - 1;
            if (!col.isVisible() || !col.isRequired() || (colValue = this.getValueAt(lastRow, col.getIndex())) != null && !colValue.toString().equals("")) continue;
            return false;
        }
        return true;
    }

    public boolean isAllowDelete() {
        return this.allowDelete || this.isEditable();
    }

    public boolean isDataModified() {
        if (this.deletedRecords.size() > 0) {
            return true;
        }
        for (JKTableRecord rec : this.records) {
            if (rec.getStatus() != JKTableRecord.RecordStatus.MODIFIED) continue;
            return true;
        }
        return false;
    }

    public boolean isEditable() {
        for (JKTableColumn col : this.tableColumns) {
            if (!col.isEditable()) continue;
            return true;
        }
        return false;
    }

    public boolean isEditable(int column) {
        return this.getTableColumn(column).isEditable();
    }

    public boolean isEditable(int row, int column) {
        if (this.isEditable(column)) {
            int actualIndex = this.getTableColumn(column).getIndex();
            JKTableRecord record = this.getRecord(row);
            return record.isColumnEnabled(actualIndex);
        }
        return false;
    }

    public boolean isNumericClumn(int visibleColIndex) {
        return this.getTableColumn(visibleColIndex).isNumeric();
    }

    protected boolean isValidTableColumnIndex(int actualIndex) {
        return actualIndex >= 0 && actualIndex < this.tableColumns.size();
    }

    public boolean isVisible(int col) {
        return this.getTableColumn(col).isVisible();
    }

    public void refreshVisibility() {
        this.visibilityManager.refreshVisibility();
        this.fireTableStructureChanged();
    }

    public JKTableRecord removeRecord(int row) {
        return this.records.remove(row);
    }

    public void resetRecords() {
        this.records.clear();
    }

    public void setAllowDelete(boolean allowDelete) {
        this.allowDelete = allowDelete;
    }

    public void setColumnValue(int row, int col, Object value, boolean visibleIndex) {
        int actualColumn = col;
        if (visibleIndex) {
            actualColumn = this.getActualColumnIndexFromVisible(col);
        }
        this.getRecord(row).setColumnValue(actualColumn, value);
        this.fireTableCellUpdated(row, col);
    }

    public void setEditable(boolean editable) {
        for (JKTableColumn col : this.tableColumns) {
            col.setEditable(editable);
        }
    }

    public void setEditable(int column, boolean editable) {
        this.getTableColumn(column).setEditable(editable);
    }

    public void setEditable(int row, int col, boolean enable) {
        int actualIndex = this.getTableColumn(col).getIndex();
        this.getRecord(row).setColumnEnabled(actualIndex, enable);
    }

    public void setEditor(int colunm, TableCellEditor cellEditor) {
        this.getTableColumn(colunm).setEditor(cellEditor);
    }

    public void setFormatter(int col, Format formatter) {
        this.getTableColumn(col).setFormatter(formatter);
    }

    public void setPreferredWidth(int col, int width) {
        this.getTableColumn(col).setPreferredWidth(width);
    }

    public void setRenderer(int col, TableCellRenderer cellRenderer) {
        this.getTableColumn(col).setRenderer(cellRenderer);
    }

    public void setRequired(int col, boolean required) {
        this.getTableColumn(col).setRequired(required);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int visibleIndex) {
        int actualColIndex = this.visibilityManager.getActualIndexFromVisibleIndex(visibleIndex);
        JKTableRecord record = this.records.get(rowIndex);
        record.setColumnValue(actualColIndex, value);
        record.setStatus(JKTableRecord.RecordStatus.MODIFIED);
        this.fireTableCellUpdated(rowIndex, visibleIndex);
        this.modified = true;
    }

    public void setVisible(int col, boolean visible) {
        this.getTableColumn(col).setVisible(visible);
        this.refreshVisibility();
    }

    public void setVisibleByActualIndex(int colunmIndex, boolean visible) {
        this.getTableColumn(colunmIndex, false).setVisible(visible);
        this.refreshVisibility();
    }

    public void addJKTableColumn(String keyLabel) {
        JKTableColumn col = new JKTableColumn();
        col.setName(keyLabel);
        this.addJKTableColumn(col);
    }

    class ColumnVisiblityManagar {
        final Vector<JKTableColumn> columns;

        public ColumnVisiblityManagar(Vector<JKTableColumn> columns) {
            this.columns = columns;
            this.refreshVisibility();
        }

        public int getActualIndexFromVisibleIndex(int visibleIndex) {
            return this.getFSTableColumnFromVisibleIndex(visibleIndex).getIndex();
        }

        public Vector<JKTableColumn> getColumns() {
            return this.columns;
        }

        public JKTableColumn getFSTableColumnFromVisibleIndex(int visibleIndex) {
            for (JKTableColumn col : this.columns) {
                if (col.getVisibleIndex() != visibleIndex) continue;
                return col;
            }
            throw new ArrayIndexOutOfBoundsException(visibleIndex);
        }

        public int getVisibleColumnCount() {
            int count = 0;
            for (JKTableColumn col : this.columns) {
                if (!col.isVisible()) continue;
                ++count;
            }
            return count;
        }

        public int getVisibleIndexFromActualIndex(int actualIndex) {
            return this.columns.get(actualIndex).getVisibleIndex();
        }

        protected void refreshVisibility() {
            int visibleIndex = 0;
            for (JKTableColumn col : this.columns) {
                if (col.isVisible()) {
                    col.setVisibleIndex(visibleIndex++);
                    continue;
                }
                col.setVisibleIndex(-1);
            }
        }
    }
}

