/*
 * Decompiled with CFR 0.152.
 */
package com.jk.util.model.table;

import com.jk.locale.JKMessage;
import com.jk.util.model.table.JKColumnFilter;
import java.math.BigDecimal;
import java.text.Format;
import java.util.Vector;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class JKTableColumn {
    int index;
    int visibleIndex;
    String name;
    boolean required;
    boolean editable;
    private String humanName;
    private Format formatter;
    private int preferredWidth;
    private TableCellRenderer cellRenderer;
    private TableCellEditor cellEditor;
    private boolean visible = true;
    private Class columnClass;
    private String columnClassName;
    private int columnType;
    private String columnTypeName;
    Vector<JKColumnFilter> filters;
    private int maxLength;
    private Object defaultValue;

    public Class getColumnClass() {
        return this.columnClass == null ? Object.class : this.columnClass;
    }

    public String getColumnClassName() {
        return this.columnClassName;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public String getColumnTypeName() {
        return this.columnTypeName;
    }

    public TableCellEditor getEditor() {
        return this.cellEditor;
    }

    public Format getFormatter() {
        return this.formatter;
    }

    public String getHumanName() {
        return this.humanName;
    }

    public int getIndex() {
        return this.index;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public String getName() {
        return this.name;
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public TableCellRenderer getRenderer() {
        return this.cellRenderer;
    }

    public int getVisibleIndex() {
        return this.isVisible() ? this.visibleIndex : -1;
    }

    public boolean isEditable() {
        return this.editable && this.isVisible();
    }

    public boolean isNumeric() {
        Class c = this.getColumnClass();
        return c.equals(Integer.class) || c.equals(Float.class) || c.equals(Long.class) || c.equals(BigDecimal.class);
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setColumnClass(Class columnClass) {
        this.columnClass = columnClass;
    }

    public void setColumnClassName(String columnClassName) throws ClassNotFoundException {
        if (columnClassName.equals("byte[]")) {
            this.setColumnClass(Object.class);
        } else {
            this.setColumnClass(Class.forName(columnClassName));
        }
        this.columnClassName = columnClassName;
    }

    public void setColumnType(int columnType) {
        this.columnType = columnType;
    }

    public void setColumnTypeName(String columnTypeName) {
        this.columnTypeName = columnTypeName;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public void setEditor(TableCellEditor cellEditor) {
        this.cellEditor = cellEditor;
    }

    public void setFormatter(Format formatter) {
        this.formatter = formatter;
    }

    public void setHumanName(String humanName) {
        this.humanName = humanName;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void setName(String name) {
        this.name = name;
        this.setHumanName(JKMessage.get(name, true));
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
    }

    public void setRenderer(TableCellRenderer cellRenderer) {
        this.cellRenderer = cellRenderer;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setVisibleIndex(int visibleIndex) {
        this.visibleIndex = visibleIndex;
    }
}

