/*
 * Decompiled with CFR 0.152.
 */
package com.jk.util.model.table;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class JKDefaultTableModel
extends AbstractTableModel
implements Serializable {
    private static final long serialVersionUID = -8125197035369796500L;
    protected Vector dataVector;
    protected Vector columnIdentifiers;

    protected static Vector convertToVector(Object[] anArray) {
        if (anArray == null) {
            return null;
        }
        Vector<Object> v = new Vector<Object>(anArray.length);
        for (Object element : anArray) {
            v.addElement(element);
        }
        return v;
    }

    protected static Vector convertToVector(Object[][] anArray) {
        if (anArray == null) {
            return null;
        }
        Vector<Vector> v = new Vector<Vector>(anArray.length);
        for (Object[] element : anArray) {
            v.addElement(JKDefaultTableModel.convertToVector(element));
        }
        return v;
    }

    private static int gcd(int i, int j) {
        return j == 0 ? i : JKDefaultTableModel.gcd(j, i % j);
    }

    private static Vector newVector(int size) {
        Vector v = new Vector(size);
        v.setSize(size);
        return v;
    }

    private static Vector nonNullVector(Vector v) {
        return v != null ? v : new Vector();
    }

    private static void rotate(Vector v, int a, int b, int shift) {
        int size = b - a;
        int r = size - shift;
        int g = JKDefaultTableModel.gcd(size, r);
        for (int i = 0; i < g; ++i) {
            int to = i;
            Object tmp = v.elementAt(a + to);
            int from = (to + r) % size;
            while (from != i) {
                v.setElementAt(v.elementAt(a + from), a + to);
                to = from;
                from = (to + r) % size;
            }
            v.setElementAt(tmp, a + to);
        }
    }

    public JKDefaultTableModel() {
        this(0, 0);
    }

    public JKDefaultTableModel(int rowCount, int columnCount) {
        this(JKDefaultTableModel.newVector(columnCount), rowCount);
    }

    public JKDefaultTableModel(Object[] columnNames, int rowCount) {
        this(JKDefaultTableModel.convertToVector(columnNames), rowCount);
    }

    public JKDefaultTableModel(Object[][] data, Object[] columnNames) {
        this.setDataVector(data, columnNames);
    }

    public JKDefaultTableModel(Vector columnNames, int rowCount) {
        this.setDataVector(JKDefaultTableModel.newVector(rowCount), columnNames);
    }

    public JKDefaultTableModel(Vector data, Vector columnNames) {
        this.setDataVector(data, columnNames);
    }

    public void addColumn(Object columnName) {
        this.addColumn(columnName, (Vector)null);
    }

    public void addColumn(Object columnName, Object[] columnData) {
        this.addColumn(columnName, JKDefaultTableModel.convertToVector(columnData));
    }

    public void addColumn(Object columnName, Vector columnData) {
        this.columnIdentifiers.addElement(columnName);
        if (columnData != null) {
            int columnSize = columnData.size();
            if (columnSize > this.getRowCount()) {
                this.dataVector.setSize(columnSize);
            }
            this.justifyRows(0, this.getRowCount());
            int newColumn = this.getColumnCount() - 1;
            for (int i = 0; i < columnSize; ++i) {
                Vector row = (Vector)this.dataVector.elementAt(i);
                row.setElementAt(columnData.elementAt(i), newColumn);
            }
        } else {
            this.justifyRows(0, this.getRowCount());
        }
        this.fireTableStructureChanged();
    }

    public void addRow(Object[] rowData) {
        this.addRow(JKDefaultTableModel.convertToVector(rowData));
    }

    public void addRow(Vector rowData) {
        this.insertRow(this.getRowCount(), rowData);
    }

    @Override
    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    @Override
    public String getColumnName(int column) {
        Object id = null;
        if (column < this.columnIdentifiers.size() && column >= 0) {
            id = this.columnIdentifiers.elementAt(column);
        }
        return id == null ? super.getColumnName(column) : id.toString();
    }

    public Vector getDataVector() {
        return this.dataVector;
    }

    @Override
    public int getRowCount() {
        return this.dataVector.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        Vector rowVector = (Vector)this.dataVector.elementAt(row);
        return rowVector.elementAt(column);
    }

    public void insertRow(int row, Object[] rowData) {
        this.insertRow(row, JKDefaultTableModel.convertToVector(rowData));
    }

    public void insertRow(int row, Vector rowData) {
        this.dataVector.insertElementAt(rowData, row);
        this.justifyRows(row, row + 1);
        this.fireTableRowsInserted(row, row);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    private void justifyRows(int from, int to) {
        this.dataVector.setSize(this.getRowCount());
        for (int i = from; i < to; ++i) {
            if (this.dataVector.elementAt(i) != null) continue;
            this.dataVector.setElementAt(new Vector(), i);
        }
    }

    public void moveRow(int start, int end, int to) {
        int last;
        int first;
        int shift = to - start;
        if (shift < 0) {
            first = to;
            last = end;
        } else {
            first = start;
            last = to + end - start;
        }
        JKDefaultTableModel.rotate(this.dataVector, first, last + 1, shift);
        this.fireTableRowsUpdated(first, last);
    }

    public void newDataAvailable(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void newRowsAdded(TableModelEvent e) {
        this.justifyRows(e.getFirstRow(), e.getLastRow() + 1);
        this.fireTableChanged(e);
    }

    public Object removeRow(int row) {
        Object removed = this.dataVector.remove(row);
        this.fireTableRowsDeleted(row, row);
        return removed;
    }

    public void rowsRemoved(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void setColumnCount(int columnCount) {
        this.columnIdentifiers.setSize(columnCount);
        this.justifyRows(0, this.getRowCount());
        this.fireTableStructureChanged();
    }

    public void setColumnIdentifiers(Object[] newIdentifiers) {
        this.setColumnIdentifiers(JKDefaultTableModel.convertToVector(newIdentifiers));
    }

    public void setColumnIdentifiers(Vector columnIdentifiers) {
        this.setDataVector(this.dataVector, columnIdentifiers);
    }

    public void setDataVector(Object[][] dataVector, Object[] columnIdentifiers) {
        this.setDataVector(JKDefaultTableModel.convertToVector(dataVector), JKDefaultTableModel.convertToVector(columnIdentifiers));
    }

    public void setDataVector(Vector dataVector, Vector columnIdentifiers) {
        this.dataVector = JKDefaultTableModel.nonNullVector(dataVector);
        this.columnIdentifiers = JKDefaultTableModel.nonNullVector(columnIdentifiers);
        this.justifyRows(0, this.getRowCount());
        this.fireTableStructureChanged();
    }

    public void setNumRows(int rowCount) {
        int old = this.getRowCount();
        if (old == rowCount) {
            return;
        }
        this.dataVector.setSize(rowCount);
        if (rowCount <= old) {
            this.fireTableRowsDeleted(rowCount, old - 1);
        } else {
            this.justifyRows(old, rowCount);
            this.fireTableRowsInserted(old, rowCount - 1);
        }
    }

    public void setRowCount(int rowCount) {
        this.setNumRows(rowCount);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        Vector rowVector = (Vector)this.dataVector.elementAt(row);
        rowVector.setElementAt(aValue, column);
        this.fireTableCellUpdated(row, column);
    }
}

