/*
 * Decompiled with CFR 0.152.
 */
package com.jk.util.model.table;

import com.jk.util.model.table.JKTableColumn;
import java.util.Vector;

public class JKColumnFilter {
    FilterType type = FilterType.CONTAINS;
    Vector values = new Vector();
    JKTableColumn column;
    boolean required;

    public JKColumnFilter(JKTableColumn column) {
        this.column = column;
    }

    public JKTableColumn getColumn() {
        return this.column;
    }

    public FilterType getType() {
        return this.type;
    }

    public Vector getValues() {
        return this.values;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setColumn(JKTableColumn column) {
        this.column = column;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setType(FilterType type) {
        this.type = type;
    }

    public void setValues(Vector values) {
        this.values = values;
    }

    public String toQueryString() {
        StringBuffer buf = new StringBuffer();
        Object value1 = this.values.get(0);
        buf.append(this.column.getName());
        switch (this.type) {
            case STARTS_WIDTH: {
                buf.append(" like '" + value1 + "%'");
                break;
            }
            case CONTAINS: {
                buf.append(" like '%" + value1 + "%'");
                break;
            }
            case ENDS_WITH: {
                buf.append(" like '%" + value1 + "'");
                break;
            }
            case DOESNOT_CONTAINS: {
                buf.append(" not like '%" + value1 + "%'");
                break;
            }
            case MORE_THAN: {
                buf.append(" > '" + value1 + "'");
                break;
            }
            case LESS_THAN: {
                buf.append(" < '" + value1 + "'");
            }
        }
        return buf.toString();
    }

    static enum FilterType {
        EQUALS,
        CONTAINS,
        MORE_THAN,
        LESS_THAN,
        BETWEEN,
        DOESNOT_CONTAINS,
        STARTS_WIDTH,
        ENDS_WITH;


        public int requiredFieldsCount() {
            if (this == BETWEEN) {
                return 2;
            }
            return 1;
        }
    }
}

