/*
 * Decompiled with CFR 0.152.
 */
package com.jk.util;

import com.jk.exceptions.handler.JKExceptionUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;

public class UserPreferences {
    private static Preferences systemRoot = Preferences.userRoot();
    private static String keyPrefix = "app-";

    public static void clear() throws BackingStoreException {
        try {
            systemRoot.clear();
        }
        catch (Exception e) {
            System.err.print(e);
        }
    }

    protected static String fixKey(String key) {
        if (key.startsWith(UserPreferences.getKeyPrefix())) {
            return key;
        }
        return UserPreferences.getKeyPrefix() + "-" + key;
    }

    public static String get(String key, String def) {
        try {
            return systemRoot.get(UserPreferences.fixKey(key), def);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static boolean getBoolean(String key, boolean def) {
        try {
            return systemRoot.getBoolean(UserPreferences.fixKey(key), def);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static float getFloat(String key, float def) {
        try {
            return systemRoot.getFloat(UserPreferences.fixKey(key), def);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static Hashtable<String, String> getHashtable(String name) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        try {
            String configStr = UserPreferences.get(UserPreferences.fixKey(name), "");
            if (!configStr.equals("")) {
                String[] rows;
                for (String row : rows = configStr.split(";")) {
                    String[] split = row.split(":");
                    if (split.length != 2) continue;
                    String key = split[0];
                    String value = split[1];
                    hash.put(key, value);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hash;
    }

    public static int getInt(String key, int def) {
        try {
            return systemRoot.getInt(UserPreferences.fixKey(key), def);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static String getKeyPrefix() {
        return keyPrefix;
    }

    public static String[] keys() throws BackingStoreException {
        try {
            return systemRoot.keys();
        }
        catch (Exception e) {
            return new String[0];
        }
    }

    public static void put(String key, String value) {
        try {
            systemRoot.put(UserPreferences.fixKey(key), value);
        }
        catch (Exception e) {
            System.err.print(e);
        }
    }

    public static void putBoolean(String key, boolean value) {
        try {
            systemRoot.putBoolean(UserPreferences.fixKey(key), value);
        }
        catch (Exception e) {
            System.err.print(e);
        }
    }

    public static void putFloat(String key, float value) {
        try {
            systemRoot.putFloat(UserPreferences.fixKey(key), value);
        }
        catch (Exception e) {
            System.err.print(e);
        }
    }

    public static void putHashTable(String name, Hashtable hash) {
        Enumeration keys = hash.keys();
        StringBuffer buf = new StringBuffer("");
        while (keys.hasMoreElements()) {
            if (!buf.toString().equals("")) {
                buf.append(";");
            }
            String key = (String)keys.nextElement();
            String value = hash.get(key).toString();
            buf.append(key + ":" + value);
        }
        UserPreferences.put(UserPreferences.fixKey(name), buf.toString());
    }

    public static void putInt(String key, int value) {
        try {
            systemRoot.putInt(UserPreferences.fixKey(key), value);
        }
        catch (Exception e) {
            System.err.print(e);
        }
    }

    public static void setKeyPrefix(String keyPrefix) {
        UserPreferences.keyPrefix = keyPrefix;
        try {
            systemRoot.sync();
        }
        catch (Exception e) {
            JKExceptionUtil.handle(e);
        }
    }

    public byte[] getByteArray(String key, byte[] def) {
        try {
            return systemRoot.getByteArray(UserPreferences.fixKey(key), def);
        }
        catch (Exception e) {
            return def;
        }
    }

    public void putByteArray(String key, byte[] value) {
        try {
            systemRoot.putByteArray(UserPreferences.fixKey(key), value);
        }
        catch (Exception e) {
            System.err.print(e);
        }
    }
}

