/*
 * Decompiled with CFR 0.152.
 */
package com.jk.util;

import java.text.DecimalFormat;

public class NumbersToWords {
    private static final String[] tensNames = new String[]{"", " Ten", " Twenty", " Thirty", " Forty", " Fifty", " Sixty", " Seventy", " Eighty", " Ninety"};
    private static final String[] numNames = new String[]{"", " One", " Two", " Three", " Four", " Five", " Six", " Seven", " Eight", " Nine", " Ten", " Eleven", " Twelve", " Thirteen", " Fourteen", " Fifteen", " Sixteen", " Seventeen", " Eighteen", " Nineteen"};

    public static String convert(long number) {
        String tradHundredThousands;
        String tradMillions;
        String tradBillions;
        if (number == 0L) {
            return "zero";
        }
        String snumber = Long.toString(number);
        String mask = "000000000000";
        DecimalFormat df = new DecimalFormat("000000000000");
        snumber = df.format(number);
        int billions = Integer.parseInt(snumber.substring(0, 3));
        int millions = Integer.parseInt(snumber.substring(3, 6));
        int hundredThousands = Integer.parseInt(snumber.substring(6, 9));
        int thousands = Integer.parseInt(snumber.substring(9, 12));
        switch (billions) {
            case 0: {
                tradBillions = "";
                break;
            }
            case 1: {
                tradBillions = NumbersToWords.convertLessThanOneThousand(billions) + " Billion ";
                break;
            }
            default: {
                tradBillions = NumbersToWords.convertLessThanOneThousand(billions) + " Billion ";
            }
        }
        String result = tradBillions;
        switch (millions) {
            case 0: {
                tradMillions = "";
                break;
            }
            case 1: {
                tradMillions = NumbersToWords.convertLessThanOneThousand(millions) + " Million ";
                break;
            }
            default: {
                tradMillions = NumbersToWords.convertLessThanOneThousand(millions) + " Million ";
            }
        }
        result = result + tradMillions;
        switch (hundredThousands) {
            case 0: {
                tradHundredThousands = "";
                break;
            }
            case 1: {
                tradHundredThousands = "One Thousand ";
                break;
            }
            default: {
                tradHundredThousands = NumbersToWords.convertLessThanOneThousand(hundredThousands) + " Thousand ";
            }
        }
        result = result + tradHundredThousands;
        String tradThousand = NumbersToWords.convertLessThanOneThousand(thousands);
        result = result + tradThousand;
        String replaceAll = result.replaceAll("^\\s+", "").replaceAll("\\b\\s{2,}\\b", " ");
        return replaceAll.trim();
    }

    private static String convertLessThanOneThousand(int number) {
        String soFar;
        if (number % 100 < 20) {
            soFar = numNames[number % 100];
            number /= 100;
        } else {
            soFar = numNames[number % 10];
            soFar = tensNames[(number /= 10) % 10] + soFar;
            number /= 10;
        }
        if (number == 0) {
            return soFar;
        }
        return numNames[number] + " Hundred" + soFar;
    }

    public static void main(String[] args) {
        System.err.println(NumbersToWords.convert(45233L));
    }
}

