/*
 * Decompiled with CFR 0.152.
 */
package com.jk.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;

public class JKStringUtil {
    public static String compile(String sql, Object ... param) {
        for (Object element : param) {
            sql = sql.replaceFirst("\\?", element.toString());
        }
        return sql;
    }

    public static String fixValue(String value) {
        if (value != null && !value.equals("")) {
            String[] words = value.toLowerCase().split("_");
            value = "";
            for (String word : words) {
                value = word.length() > 1 ? value + word.substring(0, 1).toUpperCase() + word.substring(1) + " " : word;
            }
        }
        if (value.contains("\\n")) {
            value = value.replace("\\n", System.getProperty("line.separator"));
        }
        return value;
    }

    public static String setParameters(String value, Object[] params) {
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                value = value.replaceAll("\\{" + i + "\\}", params[i].toString());
            }
        }
        return value;
    }

    public static String trim(String str) {
        return StringUtils.trim(str);
    }

    public static String capitalizeFully(String label) {
        return WordUtils.capitalizeFully(label);
    }

    public static String removeLast(String original, String string) {
        int lastIndexOf = original.lastIndexOf(string);
        if (lastIndexOf == -1) {
            return original;
        }
        return original.substring(0, lastIndexOf);
    }

    public static String escapeValue(String value) {
        value = value.replaceAll("'", "\\\\'");
        return "'" + value + "'";
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().equals("");
    }

    public static String concat(Object ... arr) {
        StringBuffer b = new StringBuffer();
        for (Object string : arr) {
            if (string == null) continue;
            b.append(string);
            b.append(" ");
        }
        return b.toString();
    }

    public static String getFirstLine(String message) {
        if (JKStringUtil.isEmpty(message)) {
            return message;
        }
        if (message.contains("\n")) {
            return message.split("\n")[0];
        }
        return message;
    }

    public static StringBuilder removeLast(StringBuilder builder, String string) {
        int lastIndexOf = builder.lastIndexOf(string);
        if (lastIndexOf == -1) {
            return builder;
        }
        return new StringBuilder(builder.substring(0, lastIndexOf));
    }

    public static void copyToClipboard(String text) {
        StringSelection stringSelection = new StringSelection(text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }
}

