/*
 * Decompiled with CFR 0.152.
 */
package com.jk.util;

import com.jk.exceptions.JKException;
import com.jk.exceptions.handler.JKExceptionUtil;
import com.jk.util.XmlEncoderExceptionListener;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class JKObjectUtil {
    public static <T> T cloneBean(Object bean) {
        try {
            return (T)BeanUtils.cloneBean(bean);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> getClass(String beanClassName) {
        try {
            return Class.forName(beanClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getPropertyValue(Object instance, String fieldName) {
        try {
            return (T)PropertyUtils.getProperty(instance, fieldName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isBoolean(Class type) {
        if (Boolean.class.isAssignableFrom(type)) {
            return true;
        }
        return type.getName().equals("boolean");
    }

    public static boolean isDate(Class type) {
        return Date.class.isAssignableFrom(type);
    }

    public static boolean isFinal(Field field) {
        return Modifier.isFinal(field.getModifiers());
    }

    public static boolean isStatic(Field field) {
        return Modifier.isStatic(field.getModifiers());
    }

    public static boolean isTime(Class type) {
        return Time.class.isAssignableFrom(type);
    }

    public static boolean isTimeStamp(Class type) {
        return Timestamp.class.isAssignableFrom(type);
    }

    public static boolean isTransient(Field field) {
        return Modifier.isTransient(field.getModifiers());
    }

    public static <T> T newInstance(Class<T> clas) {
        try {
            return clas.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> clas, Object ... params) {
        try {
            Class<?>[] paramClasses = JKObjectUtil.toClassesFromObjects(params);
            if (paramClasses.length == 0) {
                return clas.newInstance();
            }
            return ConstructorUtils.invokeConstructor(clas, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(String className) {
        try {
            return (T)Thread.currentThread().getContextClassLoader().loadClass(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void setPeopertyValue(Object source, String fieldName, Object value) {
        try {
            PropertyUtils.setProperty(source, fieldName, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> toClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?>[] toClassesFromObjects(Object[] params) {
        Class[] classes = new Class[params.length];
        int i = 0;
        for (Object object : params) {
            classes[i++] = object != null ? object.getClass() : Object.class;
        }
        return classes;
    }

    public static String toString(Object object, boolean useCurrentTostringIfAvailable) {
        if (object == null) {
            return "[NULL]";
        }
        if (useCurrentTostringIfAvailable && JKObjectUtil.isMethodDirectlyExists(object, "toString", new Class[0])) {
            return object.toString();
        }
        return ToStringBuilder.reflectionToString(object, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static String toString(Object object) {
        return JKObjectUtil.toString(object, false);
    }

    public static boolean isMethodDirectlyExists(Object object, String methodName, Class<?> ... params) {
        try {
            Method method = object.getClass().getMethod(methodName, params);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean equals(Object source, Object target) {
        if (source == null && target != null) {
            return false;
        }
        if (source == null && target == null) {
            return true;
        }
        return JKObjectUtil.toString(source).equals(JKObjectUtil.toString(target));
    }

    public static <T> T getFieldValue(Class<?> clas, Object instance, String fieldName) {
        try {
            Field declaredField = clas.getDeclaredField(fieldName);
            declaredField.setAccessible(true);
            return (T)declaredField.get(instance);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new JKException(e);
        }
    }

    public static Object callStaticMethod(Class clas, String methodName, Object ... params) {
        try {
            Class[] paramsTypes = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramsTypes[i] = Object.class;
            }
            Method method = clas.getMethod(methodName, paramsTypes);
            Object o = method.invoke(null, params);
            return o;
        }
        catch (Exception e) {
            throw new JKException(e);
        }
    }

    public static Object copy(Object source) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(source);
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            ObjectInputStream ois = new ObjectInputStream(bais);
            Object deepCopy = ois.readObject();
            return deepCopy;
        }
        catch (Exception e) {
            throw new JKException(e);
        }
    }

    public static String toXml(Object obj) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(out);
        e.setExceptionListener(new XmlEncoderExceptionListener());
        e.writeObject(obj);
        e.close();
        return out.toString();
    }

    public static Object toObject(String xml) {
        ByteArrayInputStream out = new ByteArrayInputStream(xml.getBytes());
        XMLDecoder encoder = new XMLDecoder(out);
        Object object = encoder.readObject();
        encoder.close();
        return object;
    }

    public static int hash(String name) {
        return name.hashCode();
    }

    public static <T> Class<? extends T> getGenericParamter(String handler) {
        ParameterizedType parameterizedType = (ParameterizedType)JKObjectUtil.getClass(handler).getGenericInterfaces()[0];
        Class clas = (Class)parameterizedType.getActualTypeArguments()[0];
        return clas;
    }

    public static String fixPropertyName(String name) {
        char[] charArray = name.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] != '_') continue;
            charArray[i + 1] = Character.toUpperCase(charArray[i + 1]);
        }
        name = new String(charArray).replaceAll("_", "");
        return name;
    }

    public static void populate(Object instance, Map<String, Object> values) {
        try {
            BeanUtilsBean beanUtilBean = new BeanUtilsBean();
            for (String key : values.keySet()) {
                Object value = values.get(key);
                beanUtilBean.setProperty(instance, key, value);
            }
        }
        catch (Exception e) {
            JKExceptionUtil.handle(e);
        }
    }

    public static boolean isClassAvilableInClassPath(String string) {
        try {
            Class.forName(string);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static void callMethod(Object obj, String methodName, boolean includePrivateMehtods, Object ... args) throws InvocationTargetException {
        Class[] intArgsClass = JKObjectUtil.initParamsClasses(args);
        try {
            Class<?> current;
            Method method = null;
            for (current = obj.getClass(); current != Object.class; current = current.getSuperclass()) {
                try {
                    method = current.getDeclaredMethod(methodName, intArgsClass);
                    break;
                }
                catch (NoSuchMethodException ex) {
                    continue;
                }
            }
            if (method == null) {
                throw new NoSuchMethodException("Mehtod is not found in " + current);
            }
            method.setAccessible(true);
            method.invoke(obj, args);
        }
        catch (InvocationTargetException e) {
            throw new InvocationTargetException(e.getCause());
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public static void callMethod(Object obj, String methodName, Object ... args) throws InvocationTargetException {
        JKObjectUtil.callMethod(obj, methodName, false, args);
    }

    private static Class[] initParamsClasses(Object ... args) {
        int count = 0;
        Class[] intArgsClass = null;
        if (args != null) {
            intArgsClass = new Class[args.length];
            for (Object arg : args) {
                intArgsClass[count++] = arg.getClass();
            }
        }
        return intArgsClass;
    }

    public static <T> String getInstanceVariables(Class<T> clas) {
        StringBuffer fieldsString = new StringBuffer();
        Field[] fields = clas.getDeclaredFields();
        int i = 0;
        for (Field field : fields) {
            if (i++ > 0) {
                fieldsString.append(",");
            }
            fieldsString.append(field.getName());
        }
        return fieldsString.toString();
    }
}

