/*
 * Decompiled with CFR 0.152.
 */
package com.jk.util;

import com.jk.exceptions.JKException;
import com.jk.exceptions.handler.JKExceptionUtil;
import com.jk.resources.JKResourceLoaderFactory;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;

public class JKIOUtil {
    private static final String USER_LOCAL_PATH = System.getProperty("user.home") + System.getProperty("file.separator") + "jk";
    public static final String NEW_LINE = System.getProperty("line.separator");
    static Logger logger = Logger.getLogger(JKIOUtil.class.getName());

    public static String findPathJar(Class clas) throws IllegalStateException {
        URL url;
        try {
            url = clas.getProtectionDomain().getCodeSource().getLocation();
        }
        catch (SecurityException ex) {
            url = clas.getResource(clas.getSimpleName() + ".class");
        }
        String extURL = url.toExternalForm();
        try {
            url = new URL(extURL);
        }
        catch (MalformedURLException mux) {
            // empty catch block
        }
        try {
            return new File(url.toURI()).toString();
        }
        catch (Exception ex) {
            return new File(url.getPath()).toString();
        }
    }

    public static InputStream getInputStream(String name) {
        return JKResourceLoaderFactory.getResourceLoader().getResourceAsStream(name);
    }

    public static Properties readPropertiesFile(File file) {
        if (!file.exists()) {
            logger.info(String.format("File %s doesnot exists , return empty map", file.getName()));
            return new Properties();
        }
        try {
            FileInputStream in = new FileInputStream(file);
            if (in != null) {
                return JKIOUtil.readPropertiesStream(in);
            }
        }
        catch (IOException e) {
            JKExceptionUtil.handle(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readStream(InputStream inStream) {
        byte[] byArray;
        block6: {
            DataInputStream in = null;
            try {
                in = new DataInputStream(inStream);
                int size = in.available();
                byte[] arr = new byte[size];
                in.readFully(arr);
                byArray = arr;
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        in.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            in.close();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertToString(InputStream input) throws IOException {
        try {
            if (input == null) {
                throw new IOException("Input Stream Cannot be NULL");
            }
            StringBuilder sb1 = new StringBuilder();
            try {
                String line;
                BufferedReader r1 = new BufferedReader(new InputStreamReader(input, "UTF-8"));
                while ((line = r1.readLine()) != null) {
                    sb1.append(line);
                }
            }
            finally {
                input.close();
            }
            return sb1.toString();
        }
        catch (IOException e) {
            throw new JKException(e);
        }
    }

    public static String getUserFolderPath(boolean appendFileSeprator) {
        String path = USER_LOCAL_PATH;
        JKIOUtil.checkFolderPath(path, true);
        if (appendFileSeprator) {
            path = path + System.getProperty("file.separator");
        }
        return path;
    }

    public static File checkFolderPath(String path, boolean create) {
        File file = new File(path);
        if (!file.exists()) {
            if (create) {
                file.mkdir();
            }
            return null;
        }
        return file;
    }

    public static Reader getReader(String name) {
        InputStream inputStream = JKIOUtil.getInputStream(name);
        if (inputStream != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            return reader;
        }
        return null;
    }

    public static String readFile(String string) {
        InputStream inputStream = JKIOUtil.getInputStream(string);
        if (inputStream != null) {
            return new String(JKIOUtil.readStream(inputStream));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUrlContents(String urlString) {
        HttpURLConnection con = null;
        try {
            String line;
            URL url = new URL(urlString);
            con = (HttpURLConnection)url.openConnection();
            con.connect();
            InputStream inputStream = con.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuffer contents = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                contents.append(line);
                contents.append(NEW_LINE);
            }
            inputStream.close();
            String string = contents.toString();
            return string;
        }
        catch (Exception e) {
            JKExceptionUtil.handle(e);
            String string = null;
            return string;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public static String getValueFromUrl(String url, String preText, int length) {
        String urlContents = JKIOUtil.getUrlContents(url);
        int indexOf = urlContents.indexOf(preText);
        if (indexOf != -1) {
            String substring = urlContents.substring(indexOf += preText.length(), indexOf + length);
            return substring;
        }
        return null;
    }

    public static String getExtension(String fileName, boolean withPoint) {
        int lastIndexOf = fileName.lastIndexOf(".");
        if (!withPoint) {
            return fileName.substring(lastIndexOf + 1);
        }
        return fileName.substring(lastIndexOf);
    }

    public static String removeExtension(String fileName) {
        String separator = System.getProperty("file.separator");
        int lastSeparatorIndex = fileName.lastIndexOf(separator);
        String filename = lastSeparatorIndex == -1 ? fileName : fileName.substring(lastSeparatorIndex + 1);
        int extensionIndex = filename.lastIndexOf(".");
        if (extensionIndex == -1) {
            return filename;
        }
        fileName = fileName.substring(0, lastSeparatorIndex);
        return fileName + File.separator + filename.substring(0, extensionIndex);
    }

    public static File writeDataToFile(byte[] data, File file) {
        return JKIOUtil.writeDataToFile(data, file, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File writeDataToFile(byte[] data, File file, boolean append) {
        try (FileOutputStream out = new FileOutputStream(file, append);){
            out.write(data);
            out.close();
            File file2 = file;
            return file2;
        }
        catch (Exception e) {
            JKExceptionUtil.handle(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readPropertiesStream(InputStream inputStream) {
        try {
            Properties prop = new Properties();
            prop.load(inputStream);
            Properties properties = prop;
            return properties;
        }
        catch (IOException e) {
            JKExceptionUtil.handle(e);
            Properties properties = null;
            return properties;
        }
        finally {
            JKIOUtil.close(inputStream);
        }
    }

    private static void close(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static File writeDataToTempFile(byte[] data, String suffix) {
        try {
            File file = File.createTempFile("fs-", suffix);
            return JKIOUtil.writeDataToFile(data, file);
        }
        catch (IOException e) {
            JKExceptionUtil.handle(e);
            return null;
        }
    }

    public static File writeDataToTempFile(String data, String ext) {
        try {
            File file = JKIOUtil.createTempFile(ext);
            PrintWriter out = new PrintWriter(new FileOutputStream(file));
            out.print(data);
            out.close();
            return file;
        }
        catch (IOException e) {
            JKExceptionUtil.handle(e);
            return null;
        }
    }

    public static File createTempFile(String ext) throws IOException {
        File file = File.createTempFile("fs-", "." + ext);
        return file;
    }

    public static URL getURL(String path) {
        return JKResourceLoaderFactory.getResourceLoader().getResourceUrl(path);
    }

    public static Properties readPropertiesFile(String fileName) {
        InputStream in = JKIOUtil.getInputStream(fileName);
        if (in != null) {
            return JKIOUtil.readPropertiesStream(in);
        }
        return new Properties();
    }

    public static InputStream getReportFileAsStream(String name) {
        return JKIOUtil.getInputStream("/resources/reports/".concat(name).concat(".jrxml"));
    }

    public static Process executeFile(String fileName) {
        try {
            String command = "cmd /c \"" + fileName + "\"";
            logger.info(command);
            return Runtime.getRuntime().exec(command);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSqlFile(String fileName) {
        return JKIOUtil.readFile("/resources/sql/".concat(fileName));
    }
}

