/*
 * Decompiled with CFR 0.152.
 */
package com.jk.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class JKFormatUtil {
    public static final String DEFAULT_DATE_PATTERN = "dd/MM/yyyy";
    public static final String DEFAULT_TIME_PATTERN = "hh:mm:ss";
    public static final String DEFAULT_TIMESTAMP_PATTERN = "dd/MM/yyyy hh:mm:ss";
    public static final String DEFAULT_DOUBLE_FORMAT = "###,###,##0.000";
    public static final String DEFAULT_NUMBER_FORMAT = "###,###,##0";
    public static final String MYSQL_DATE_DB_PATTERN = "yyyy-MM-dd";
    public static Map<String, Format> formatMap = new LinkedHashMap<String, Format>();

    public static String format(Object object, String pattern) {
        if (object instanceof java.sql.Date) {
            return JKFormatUtil.formatDate((java.sql.Date)object, pattern);
        }
        if (object instanceof Time) {
            return JKFormatUtil.formatTime((Time)object, pattern);
        }
        if (object instanceof Timestamp) {
            return JKFormatUtil.formatTimeStamp((Timestamp)object, pattern);
        }
        if (object instanceof Date) {
            return JKFormatUtil.formatDate((Date)object, pattern);
        }
        if (object instanceof Double) {
            return JKFormatUtil.formatDouble((Double)object, pattern);
        }
        if (object != null) {
            return object.toString();
        }
        return null;
    }

    public static synchronized String formatDate(Date object, String pattern) {
        if (pattern == null || pattern.equals("")) {
            pattern = DEFAULT_DATE_PATTERN;
        }
        return JKFormatUtil.getDateFormatter(pattern).format(object);
    }

    public static String formatDouble(Double amount, String pattern) {
        if (pattern == null || pattern.equals("")) {
            pattern = DEFAULT_DOUBLE_FORMAT;
        }
        return JKFormatUtil.getNumberFormatter(pattern).format(amount);
    }

    public static synchronized String formatTime(Time object, String pattern) {
        if (pattern == null || pattern.equals("")) {
            pattern = DEFAULT_TIME_PATTERN;
        }
        return JKFormatUtil.getDateFormatter(pattern).format(object);
    }

    public static synchronized String formatTimeStamp(Timestamp date, String pattern) {
        if (pattern == null || pattern.equals("")) {
            pattern = DEFAULT_TIMESTAMP_PATTERN;
        }
        return JKFormatUtil.getDateFormatter(pattern).format(date);
    }

    public static Format getDateFormatter(String pattern) {
        Format format = formatMap.get(pattern);
        if (format == null) {
            format = new SimpleDateFormat(pattern);
            formatMap.put(pattern, format);
        }
        return format;
    }

    public static Format getNumberFormatter(String pattern) {
        Format format = formatMap.get(pattern);
        if (format == null) {
            format = new DecimalFormat(pattern);
            formatMap.put(pattern, format);
        }
        return format;
    }

    public static String formatNumber(Number count) {
        Format numberFormatter = JKFormatUtil.getNumberFormatter(DEFAULT_NUMBER_FORMAT);
        return numberFormatter.format(count);
    }

    public static String formatDate(Date date) {
        return JKFormatUtil.formatDate(date, DEFAULT_DATE_PATTERN);
    }

    public static String formatTime(Time time) {
        return JKFormatUtil.formatDate(time, "hh:mm");
    }
}

