/*
 * Decompiled with CFR 0.152.
 */
package com.jk.util;

import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import com.jk.util.JKIOUtil;
import com.jk.util.model.table.JKTableModel;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import javax.swing.JFileChooser;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class JKExcelUtil {
    private static JFileChooser fileChooser = new JFileChooser();
    private final HSSFSheet sheet;
    private final HSSFWorkbook workbook;
    private final JKTableModel model;
    private JKLogger logger = JKLoggerFactory.getLogger(this.getClass());

    public static void buildExcelSheet(JKTableModel model) {
        JKExcelUtil sheet = new JKExcelUtil(model);
        try {
            File file = JKIOUtil.createTempFile("xls");
            sheet.writeTo(file);
            JKIOUtil.executeFile(file.getAbsolutePath());
            file.deleteOnExit();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public JKExcelUtil(JKTableModel model) {
        this.workbook = new HSSFWorkbook();
        this.sheet = this.workbook.createSheet();
        this.model = model;
        this.createColumnHeaders();
        this.createRows();
        this.setColumnsWidth();
    }

    protected void createColumnHeaders() {
        HSSFRow headersRow = this.sheet.createRow(0);
        HSSFFont font = this.workbook.createFont();
        font.setBoldweight((short)700);
        HSSFCellStyle style = this.workbook.createCellStyle();
        style.setFont(font);
        style.setAlignment((short)2);
        int counter = 1;
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            HSSFCell cell = headersRow.createCell(counter++);
            cell.setCellValue(this.model.getColumnName(i));
            cell.setCellStyle(style);
        }
    }

    protected void createRow(int rowIndex) {
        HSSFRow row = this.sheet.createRow(rowIndex + 1);
        HSSFCellStyle style = this.workbook.createCellStyle();
        style.setAlignment((short)2);
        int counter = 1;
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            HSSFCell cell = row.createCell(counter++);
            Object value = this.model.getValueAt(rowIndex, i);
            this.setValue(cell, value);
            cell.setCellStyle(style);
        }
    }

    protected void createRows() {
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            this.createRow(i);
        }
    }

    protected void setColumnsWidth() {
        int counter = 1;
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            if (!this.model.isVisible(i)) continue;
            this.sheet.autoSizeColumn(counter++);
        }
    }

    private void setValue(HSSFCell cell, Object value) {
        if (value == null) {
            cell.setCellValue("-");
        } else if (value instanceof Float || value instanceof Double || value instanceof Integer || value instanceof Long || value instanceof BigDecimal) {
            cell.setCellValue(Double.parseDouble(value.toString()));
        } else if (value instanceof String) {
            cell.setCellValue(value.toString());
        } else if (value instanceof Date) {
            cell.setCellValue((Date)value);
        } else {
            this.logger.info("No Special excel r endering for class : " + value.getClass().getName());
            cell.setCellValue(value.toString());
        }
    }

    public void writeTo(File file) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        this.workbook.write(fout);
        ((OutputStream)fout).close();
    }

    public void writeTo(OutputStream out) throws IOException {
        this.workbook.write(out);
    }
}

