/*
 * Decompiled with CFR 0.152.
 */
package com.jk.util;

import com.jk.exceptions.JKException;
import com.jk.time.JKTimeObject;
import com.jk.util.JKFormatUtil;
import java.sql.Time;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class JKDateTimeUtil {
    public static Date parseDate(String strDate, String pattern) {
        try {
            SimpleDateFormat parser = new SimpleDateFormat(pattern, Locale.US);
            return parser.parse(strDate);
        }
        catch (ParseException e) {
            throw new JKException(e);
        }
    }

    public static String formatDate(Date date, String pattren) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattren, new Locale("en", "US"));
        if (date == null) {
            return "";
        }
        return formatter.format(date);
    }

    public static String formatFullTime(Date date) {
        return JKDateTimeUtil.formatDate(date, "hh:mm:ss SSS");
    }

    public static String getCurrentTime() {
        return JKDateTimeUtil.formatFullTime(new Date());
    }

    public static int getCurrentYear() {
        Calendar cal = Calendar.getInstance();
        return cal.get(1);
    }

    public static int getCurrentMonth() {
        return JKDateTimeUtil.getMonthFromDate(new Date());
    }

    public static int getYearFromData(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(1);
    }

    public static int getMonthFromDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(2) + 1;
    }

    public static String formatTime(Date date) {
        return JKFormatUtil.formatDate(date, "hh:mm");
    }

    public static boolean isTimesEqaualed(Date time1, Date time2) {
        return JKDateTimeUtil.formatTime(time1).equals(JKDateTimeUtil.formatTime(time2));
    }

    public static int getNumOfMonths(Date date1, Date date2) {
        Calendar firstDate = Calendar.getInstance();
        Date date = new Date(date1.getTime());
        firstDate.setTime(date);
        Calendar secondDate = Calendar.getInstance();
        Date date3 = new Date(date2.getTime());
        secondDate.setTime(date3);
        int months = firstDate.get(2) - secondDate.get(2);
        return months;
    }

    public static String formatCurrentDate() {
        return JKFormatUtil.formatDate(new Date(), "yyyy-MM-dd");
    }

    public static CompareDates compareTwoDates(Date date1, Date date2) {
        Date d2;
        Date d1 = new Date(date1.getTime());
        if (d1.compareTo(d2 = new Date(date2.getTime())) < 0) {
            return CompareDates.DATE1_LESS_THAN_DATE2;
        }
        if (d1.compareTo(d2) > 0) {
            return CompareDates.DATE1_GREATER_THAN_DATE2;
        }
        return CompareDates.DATE1_EQUAL_DATE2;
    }

    public static Date adddDaysToCurrentDate(int numberOfDays) {
        Date date = new Date();
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(5, numberOfDays);
        return instance.getTime();
    }

    public static boolean isDate(String strDate, String pattern) {
        try {
            JKDateTimeUtil.parseDate(strDate, pattern);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Date adddMonths(int numOfMonths) {
        return JKDateTimeUtil.addMonths(new Date(), numOfMonths);
    }

    public static Date addMonths(Date date, int numOfMonths) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(2, numOfMonths);
        return instance.getTime();
    }

    public static long getDifference(Time timeFrom, Time timeTo) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss");
            Date date = format.parse(timeFrom.toString());
            Date date2 = format.parse(timeTo.toString());
            long difference = (date2.getTime() - date.getTime()) / 1000L / 60L;
            return difference;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int getCurrentDayInMonth() {
        Date date = new Date();
        return JKDateTimeUtil.getDayOfMonth(date);
    }

    private static int getDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(5);
    }

    public static int getDayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.get(7);
    }

    public static boolean isTimeConflict(Time timeFrom, Time timeTo, Time otherTimeFrom, Time otherTimeTo) {
        if (JKDateTimeUtil.isTimesEqaualed(timeFrom, otherTimeFrom) || JKDateTimeUtil.isTimesEqaualed(timeTo, otherTimeTo)) {
            return true;
        }
        if (timeFrom.after(otherTimeFrom) && timeFrom.before(otherTimeTo)) {
            return true;
        }
        if (timeTo.after(otherTimeFrom) && timeTo.before(otherTimeTo)) {
            return true;
        }
        return timeFrom.before(otherTimeFrom) && timeTo.after(otherTimeTo);
    }

    public static int getHour(Date timeFrom) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(timeFrom);
        int hour = instance.get(10);
        return hour;
    }

    public static boolean equals(Date date1, Date date2) {
        if (date1 == null && date2 != null || date1 != null && date2 == null) {
            return false;
        }
        return JKDateTimeUtil.formatDate(date1, "yyyy-MM-dd").equals(JKDateTimeUtil.formatDate(date2, "yyyy-MM-dd"));
    }

    public static boolean isCurrentTimeBetweenTowTimes(Date fromDate, Date fromTime, Date toDate, Date timeTo) {
        JKTimeObject currntTime = JKDateTimeUtil.getCurrntTime();
        JKTimeObject fromTimeObject = new JKTimeObject();
        JKTimeObject toTimeObject = new JKTimeObject();
        return currntTime.after(fromTimeObject.toTimeObject(fromDate, fromTime)) && currntTime.before(toTimeObject.toTimeObject(toDate, timeTo));
    }

    public static JKTimeObject getCurrntTime() {
        JKTimeObject fsTimeObject = new JKTimeObject();
        Calendar instance = Calendar.getInstance();
        fsTimeObject.setYear(instance.get(1));
        fsTimeObject.setMonth(instance.get(2));
        fsTimeObject.setDay(instance.get(5));
        fsTimeObject.setHour(instance.get(11));
        fsTimeObject.setMunite(instance.get(12));
        return fsTimeObject;
    }

    public static long getDayDifference(Date startDate, Date endDate) {
        long startTime = startDate.getTime();
        long endTime = endDate.getTime();
        long diffTime = endTime - startTime;
        long diffDays = diffTime / 86400000L;
        return diffDays;
    }

    public static boolean isDateEqaualed(Date date1, Date date2) {
        String d1 = JKFormatUtil.formatDate(date1, "yyyy-MM-dd");
        String d2 = JKFormatUtil.formatDate(date2, "yyyy-MM-dd");
        return d1.equalsIgnoreCase(d2);
    }

    public static boolean isPeriodActive(Date startDate, Date endDate) {
        if (startDate == null && endDate == null) {
            return true;
        }
        if (startDate == null) {
            throw new JKException("START_DATE_CAN_NOT_BE_NULL");
        }
        if (endDate == null) {
            throw new JKException("END_DATE_CAN_NOT_BE_NULL");
        }
        if (JKDateTimeUtil.compareTwoDates(startDate, endDate).equals((Object)CompareDates.DATE1_GREATER_THAN_DATE2)) {
            throw new JKException("START_DATE_MUST_BE_BEFORE_END_DATE");
        }
        boolean startLessThanCurrent = JKDateTimeUtil.compareTwoDates(startDate, JKDateTimeUtil.getSystemDate()).equals((Object)CompareDates.DATE1_LESS_THAN_DATE2);
        boolean endGreaterThanCurrent = JKDateTimeUtil.compareTwoDates(endDate, JKDateTimeUtil.getSystemDate()).equals((Object)CompareDates.DATE1_GREATER_THAN_DATE2);
        return startLessThanCurrent && endGreaterThanCurrent;
    }

    public static Date getSystemDate() {
        return new Date();
    }

    public static Date parseDate(String date) {
        return JKDateTimeUtil.parseDate(date, "dd/MM/yyyy");
    }

    public static enum CompareDates {
        DATE1_LESS_THAN_DATE2,
        DATE1_GREATER_THAN_DATE2,
        DATE1_EQUAL_DATE2;

    }
}

