/*
 * Decompiled with CFR 0.152.
 */
package com.jk.util;

import com.jk.exceptions.handler.JKExceptionUtil;
import java.io.File;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;

public class JKCompressionUtil {
    public static void compress(String fileName, String compressedFileName, String password) {
        try {
            ZipParameters zipParameters = new ZipParameters();
            zipParameters.setCompressionMethod(8);
            zipParameters.setCompressionLevel(9);
            if (password != null) {
                zipParameters.setEncryptFiles(true);
                zipParameters.setEncryptionMethod(99);
                zipParameters.setAesKeyStrength(3);
                zipParameters.setPassword(password);
            }
            String destinationZipFilePath = compressedFileName;
            ZipFile zipFile = new ZipFile(destinationZipFilePath);
            zipFile.addFile(new File(fileName), zipParameters);
        }
        catch (ZipException e) {
            JKExceptionUtil.handle(e);
        }
    }

    public void decompress(String sourceZipFilePath, String extractedZipFilePath, String password) {
        try {
            ZipFile zipFile = new ZipFile(sourceZipFilePath);
            if (zipFile.isEncrypted()) {
                zipFile.setPassword(password);
            }
            zipFile.extractAll(extractedZipFilePath);
        }
        catch (Exception e) {
            JKExceptionUtil.handle(e);
        }
    }
}

