/*
 * Decompiled with CFR 0.152.
 */
package com.jk.util;

import com.jk.util.JKObjectUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class JKCollectionUtil {
    public static void fixPropertiesKeys(Properties prop) {
        Enumeration<Object> keys = prop.keys();
        while (keys.hasMoreElements()) {
            String currentKey = (String)keys.nextElement();
            String fixedKey = JKCollectionUtil.fixPropertyKey(currentKey);
            String value = prop.getProperty(currentKey);
            prop.remove(currentKey);
            prop.setProperty(fixedKey, value);
        }
    }

    public static String fixPropertyKey(String name) {
        return name.toLowerCase().replace("_", "-");
    }

    public static Object gatRandomItem(List items) {
        if (items == null || items.size() == 0) {
            return null;
        }
        int itemIndex = (int)(Math.random() * (double)items.size());
        return items.get(itemIndex);
    }

    public static void unifyReferences(Hashtable hash, List list) {
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object itemAtList = list.get(i);
                Object unifiedReferences = JKCollectionUtil.unifyReferences(hash, itemAtList);
                list.set(i, unifiedReferences);
            }
        }
    }

    public static Object unifyReferences(Hashtable hash, Object object) {
        Object itemAtHash = hash.get(object.hashCode());
        if (itemAtHash == null) {
            hash.put(object.hashCode(), object);
        } else {
            object = itemAtHash;
        }
        return object;
    }

    public static String toString(List<?> list) {
        StringBuffer buf = new StringBuffer("[");
        int i = 0;
        for (Object object : list) {
            if (i++ > 0) {
                buf.append(",");
            }
            buf.append(object == null ? "null" : JKObjectUtil.toString(object, true));
        }
        buf.append("]");
        return buf.toString();
    }

    public static String toString(Properties properties) {
        Properties newProperties = new Properties();
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (key.toLowerCase().contains("password")) continue;
            newProperties.setProperty(key, properties.getProperty(key));
        }
        return newProperties.toString();
    }

    public static List<Map.Entry> sortHashTable(Hashtable<?, ?> hash, boolean asc) {
        ArrayList<Map.Entry> myArrayList = new ArrayList<Map.Entry>(hash.entrySet());
        Collections.sort(myArrayList, new HashComparator(asc));
        return myArrayList;
    }

    static class HashComparator
    implements Comparator<Object> {
        private final boolean asc;

        public HashComparator(boolean asc) {
            this.asc = asc;
        }

        @Override
        public int compare(Object obj1, Object obj2) {
            Comparable value2;
            int result = 0;
            Map.Entry e1 = (Map.Entry)obj1;
            Map.Entry e2 = (Map.Entry)obj2;
            Comparable value1 = (Comparable)e1.getValue();
            if (value1.compareTo(value2 = (Comparable)e2.getValue()) == 0) {
                Comparable key1 = (Comparable)e1.getKey();
                Comparable key2 = (Comparable)e2.getKey();
                result = key1.compareTo(key2);
            } else {
                result = this.asc ? value1.compareTo(value2) : value2.compareTo(value1);
            }
            return result;
        }
    }
}

