/*
 * Decompiled with CFR 0.152.
 */
package com.jk.security;

import com.jk.logging.JKLogger;
import com.jk.logging.JKLoggerFactory;
import com.jk.security.JKAuthenticaor;
import com.jk.security.JKAuthorizer;
import com.jk.security.JKEncDec;
import com.jk.security.JKPrivilige;
import com.jk.security.JKUser;

public class JKSecurityManager {
    static JKLogger logger = JKLoggerFactory.getLogger(JKSecurityManager.class);
    static JKAuthenticaor authenticaor;
    static JKAuthorizer authorizer;
    private static JKUser currentUser;

    public static void checkAllowedPrivilige(JKPrivilige privilige) {
        logger.debug("checkAllowedPrivilige() : ", privilige);
        JKAuthorizer auth = JKSecurityManager.getAuthorizer();
        auth.checkAllowed(privilige);
    }

    public static JKAuthenticaor getAuthenticaor() {
        if (authenticaor == null) {
            throw new IllegalStateException("Please set Auth implmentation");
        }
        return authenticaor;
    }

    public static JKAuthorizer getAuthorizer() {
        if (authorizer == null) {
            throw new IllegalStateException("Please set Auth implmentation");
        }
        return authorizer;
    }

    public static JKUser getCurrentUser() {
        if (currentUser == null) {
            throw new IllegalStateException("Current user cannot be null");
        }
        return currentUser;
    }

    public static boolean isUserLoggedIn() {
        return currentUser != null;
    }

    public static void setAuthenticaor(JKAuthenticaor authenticaor) {
        JKSecurityManager.authenticaor = authenticaor;
    }

    public static void setAuthorizer(JKAuthorizer authorizer) {
        JKSecurityManager.authorizer = authorizer;
    }

    public static void setCurrentUser(JKUser currentUser) {
        JKSecurityManager.currentUser = currentUser;
    }

    public static boolean matchPassword(String plain, JKUser user) {
        return JKEncDec.encode(plain).equals(user.getPassword());
    }

    public static String encryptPassword(String text) {
        return JKEncDec.encode(text);
    }

    public static JKPrivilige createPrivilige(String name, JKPrivilige parent) {
        return JKSecurityManager.createPrivilige(name, parent, 0);
    }

    public static JKPrivilige createPrivilige(String name, JKPrivilige parent, int number) {
        logger.debug("createPriviligeObject(): Id : ", ".name", name, ", Parent:[", parent, "] , ", number);
        JKPrivilige p = new JKPrivilige(name, parent, number);
        p.setDesc(p.getFullName());
        return p;
    }
}

