/*
 * Decompiled with CFR 0.152.
 */
package com.jk.resources;

import com.jk.exceptions.JKException;
import com.jk.resources.JKResourceLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class JKDefaultResourceLoader
implements JKResourceLoader {
    @Override
    public InputStream getResourceAsStream(String resourceName) {
        URL url = this.getResourceUrl(resourceName);
        if (url != null) {
            try {
                return url.openStream();
            }
            catch (IOException e) {
                throw new JKException(e);
            }
        }
        return null;
    }

    @Override
    public URL getResourceUrl(String fileName) {
        File file;
        if (fileName == null) {
            return null;
        }
        URL resource = this.getClass().getResource(fileName);
        if (resource == null && (resource = Thread.currentThread().getContextClassLoader().getResource(fileName)) == null && (resource = ClassLoader.getSystemResource(fileName)) == null && (file = new File(fileName)).exists()) {
            try {
                resource = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new JKException(e);
            }
        }
        return resource;
    }
}

