/*
 * Decompiled with CFR 0.152.
 */
package com.jk.mime;

import com.jk.mime.InvalidMagicMimeEntryException;
import com.jk.mime.MagicMimeEntry;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Properties;

public class MimeUtil {
    public static final String UNKNOWN_MIME_TYPE = "application/x-unknown-mime-type";
    private static ByteOrder nativeByteOrder = ByteOrder.nativeOrder();
    private static Properties mimeTypes = new Properties();
    private static ArrayList<MagicMimeEntry> mMagicMimeEntries = new ArrayList();

    private static void addEntry(ArrayList<String> aStringArray) {
        try {
            MagicMimeEntry magicEntry = new MagicMimeEntry(aStringArray);
            mMagicMimeEntries.add(magicEntry);
        }
        catch (InvalidMagicMimeEntryException invalidMagicMimeEntryException) {
            // empty catch block
        }
    }

    private static String getMagicMimeType(byte[] bytes) throws IOException {
        int len = mMagicMimeEntries.size();
        for (int i = 0; i < len; ++i) {
            MagicMimeEntry me = mMagicMimeEntries.get(i);
            String mtype = me.getMatch(bytes);
            if (mtype == null) continue;
            return mtype;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMimeType(byte[] data) {
        String mimeType = null;
        try {
            mimeType = MimeUtil.getMagicMimeType(data);
        }
        catch (Exception exception) {
        }
        finally {
            if (mimeType == null) {
                mimeType = UNKNOWN_MIME_TYPE;
            }
        }
        return mimeType;
    }

    public static void init(InputStream mimeTypes, InputStream magicStream) throws IOException {
        MimeUtil.mimeTypes.load(mimeTypes);
        MimeUtil.parse(new InputStreamReader(magicStream));
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
    }

    private static void parse(Reader r) throws IOException {
        BufferedReader br = new BufferedReader(r);
        ArrayList<String> sequence = new ArrayList<String>();
        String line = br.readLine();
        block0: while (line != null) {
            if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') {
                line = br.readLine();
                continue;
            }
            sequence.add(line);
            while (true) {
                if ((line = br.readLine()) == null) {
                    MimeUtil.addEntry(sequence);
                    sequence.clear();
                    continue block0;
                }
                if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                if (line.charAt(0) != '>') {
                    MimeUtil.addEntry(sequence);
                    sequence.clear();
                    continue block0;
                }
                sequence.add(line);
            }
        }
        if (!sequence.isEmpty()) {
            MimeUtil.addEntry(sequence);
        }
    }
}

