/*
 * Decompiled with CFR 0.152.
 */
package com.jk.metadata.db.query;

import com.jk.metadata.db.query.Keyword;
import com.jk.metadata.db.query.ObjectComponent;
import com.jk.metadata.db.query.QueryComponent;
import java.util.ArrayList;
import java.util.List;

public class Query {
    ArrayList<QueryComponent> structor = new ArrayList();

    public Query addComponent(QueryComponent component) {
        this.structor.add(component);
        return this;
    }

    public Query addComponent(QueryComponent component, int count, QueryComponent separator, boolean surroundWithParenchthisis) {
        ArrayList<QueryComponent> components = new ArrayList<QueryComponent>();
        for (int i = 0; i < count; ++i) {
            components.add(component);
        }
        this.addComponents(components, separator, surroundWithParenchthisis);
        return this;
    }

    public Query addComponents(List<QueryComponent> components, QueryComponent separator, boolean surroundWithParenchthisis) {
        if (surroundWithParenchthisis) {
            this.addComponent(Keyword.LEFT_PARENTHESES);
        }
        for (int i = 0; i < components.size(); ++i) {
            if (i != 0) {
                this.addComponent(separator);
            }
            this.addComponent(components.get(i));
        }
        if (surroundWithParenchthisis) {
            this.addComponent(Keyword.RIGHT_PARENTHESES);
        }
        return this;
    }

    public Query addValue(Object value) {
        this.addComponent(new ObjectComponent(value));
        return this;
    }

    public Query addValues(ArrayList<Object> values, QueryComponent separator, boolean surroundWithParenchthisis) {
        ArrayList<QueryComponent> components = new ArrayList<QueryComponent>();
        for (Object value : values) {
            components.add(new ObjectComponent(value));
        }
        this.addComponents(components, separator, surroundWithParenchthisis);
        return this;
    }

    public String compile() {
        StringBuffer buf = new StringBuffer();
        for (QueryComponent comp : this.structor) {
            buf.append(comp.toQueryElement());
            buf.append(comp.isInline() ? " " : "\n");
        }
        return buf.toString();
    }
}

