/*
 * Decompiled with CFR 0.152.
 */
package com.jk.metadata.db.meta;

import com.jk.exceptions.handler.JKExceptionUtil;
import com.jk.locale.JKMessage;
import com.jk.metadata.db.constraints.Constraint;
import com.jk.metadata.db.constraints.TableDataValidator;
import com.jk.metadata.db.constraints.TableDataValidatorFactory;
import com.jk.metadata.db.meta.Field;
import com.jk.metadata.db.meta.FieldGroup;
import com.jk.metadata.db.meta.FieldMeta;
import com.jk.metadata.db.meta.ForiegnKeyFieldMeta;
import com.jk.metadata.db.meta.IdFieldMeta;
import com.jk.metadata.db.meta.Record;
import com.jk.metadata.db.query.QueryComponent;
import com.jk.metadata.db.trigger.Trigger;
import com.jk.security.JKPrivilige;
import com.jk.security.JKSecurityManager;
import com.jk.util.JKIOUtil;
import com.jk.util.JKObjectUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class TableMeta
implements Serializable,
QueryComponent {
    private static final long serialVersionUID = 2829460516590650258L;
    public static final int PAGE_ROW_COUNT = 25;
    public static final boolean ALLOW_MANAGE = false;
    public static final int UI_COLUMN_COUNT = 12;
    private static final String ADD_RECORD_PRIVILIGE = "ADD";
    private static final String UPDATE_RECORD_PRIVILIGE = "UPDATE";
    private static final String DELETE_RECORD_PRIVILIGE = "DELETE";
    private static final String DELETE_ALL_RECORD_PRIVILIGE = "DELETE_ALL";
    String beanName;
    String tableName;
    IdFieldMeta idField;
    Hashtable<String, FieldMeta> fields = new Hashtable();
    Vector<FieldMeta> fieldList = new Vector();
    String reportSql;
    String shortReportSql;
    String listSql;
    TableDataValidator tableDataValidator;
    int maxRecordsCount;
    private ArrayList<Constraint> constraints = new ArrayList();
    private int[] filters = new int[0];
    ArrayList<ForiegnKeyFieldMeta> detailFields = new ArrayList();
    private boolean crossTable;
    boolean allowManage = false;
    String iconName;
    String caption;
    int pageRowCount = 25;
    private int defaultUIRowCount = 12;
    private String panelClassName;
    private String managePanelClassName;
    private boolean allowDelete = true;
    private boolean allowAdd = true;
    private boolean allowUpdate = true;
    private String tableId;
    HashSet<String> triggerNames = new HashSet();
    ArrayList<Trigger> triggers = null;
    private ArrayList<FieldMeta> visibleFields;
    private String source;
    Vector<FieldGroup> groups = new Vector();
    private JKPrivilige parentPrivilige;

    public void addDetailField(ForiegnKeyFieldMeta field) {
        if (this.detailFields.indexOf(field) == -1) {
            this.detailFields.add(field);
        }
    }

    public void addDetailTable(TableMeta tableMeta) {
        this.addDetailField((ForiegnKeyFieldMeta)tableMeta.getField(this.getIdField().getName()));
    }

    public void addDetailTables(TableMeta ... detailTableNames) {
        for (TableMeta tableMeta : detailTableNames) {
            this.addDetailTable(tableMeta);
        }
    }

    public void addField(FieldMeta field) {
        if (this.fields.get(field.getName()) != null) {
            return;
        }
        field.setParentTable(this);
        this.fields.put(field.getName(), field);
        this.fieldList.add(field);
    }

    public void addFields(ArrayList<ForiegnKeyFieldMeta> foriegnFields) {
        for (int i = 0; i < foriegnFields.size(); ++i) {
            this.addField(foriegnFields.get(i));
        }
    }

    public void addGroup(FieldGroup group) {
        this.groups.add(group);
        Vector<FieldMeta> fields = group.getFields();
        for (FieldMeta fieldMeta : fields) {
            if (fieldMeta instanceof IdFieldMeta) {
                this.setIdField((IdFieldMeta)fieldMeta);
                continue;
            }
            this.addField(fieldMeta);
        }
    }

    public void addTriggerName(String triggerName) {
        this.triggerNames.add(triggerName);
    }

    public TableMeta copy() throws Exception {
        return (TableMeta)JKObjectUtil.copy(this);
    }

    private FieldGroup createDefaultGroup() {
        FieldGroup group = new FieldGroup();
        group.addField(this.idField);
        Vector<FieldMeta> fieldList = this.getFieldList();
        for (FieldMeta fieldMeta : fieldList) {
            group.addField(fieldMeta);
        }
        return group;
    }

    public Record createEmptyRecord() {
        return this.createEmptyRecord(false);
    }

    public Record createEmptyRecord(boolean setDefaultValues) {
        Record record = new Record(this);
        record.setIdField(new Field(this.idField));
        for (int i = 0; i < this.getFieldList().size(); ++i) {
            Field field = new Field(this.getFieldList().get(i));
            if (setDefaultValues) {
                field.setValue(field.getMeta().getDefaultValue());
            }
            record.addField(field);
        }
        record.setNewRecord(true);
        return record;
    }

    public Record createEmptyRecord(boolean setDefaultValues, Record defaults) {
        Record record = this.createEmptyRecord(setDefaultValues);
        record.setValues(true, defaults);
        return record;
    }

    public boolean equals(Object obj) {
        TableMeta that = (TableMeta)obj;
        return that.getTableName().equals(this.getTableName());
    }

    public Vector<FieldMeta> getAllFields() {
        Vector<FieldMeta> fields = new Vector<FieldMeta>();
        fields.add(this.getIdField());
        fields.addAll(this.getFieldList());
        return fields;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getCaption() {
        return this.caption == null || this.caption.equals("") ? this.getTableId() : this.caption;
    }

    public ArrayList<Constraint> getConstraints() {
        return this.constraints;
    }

    private String getDefaultSql() {
        return "SELECT * FROM " + this.getTableName();
    }

    public int getDefaultUIRowCount() {
        return this.defaultUIRowCount;
    }

    public ArrayList<ForiegnKeyFieldMeta> getDetailFields() {
        return this.detailFields;
    }

    public FieldMeta getField(String fieldName) {
        return this.getField(fieldName, false);
    }

    public FieldMeta getField(String fieldName, boolean includingId) {
        if (includingId && this.idField != null && this.getIdField().getName().equalsIgnoreCase(fieldName)) {
            return this.getIdField();
        }
        return this.fields.get(fieldName);
    }

    public Vector<FieldMeta> getFieldList() {
        return this.fieldList;
    }

    public Hashtable<String, FieldMeta> getFields() {
        return this.fields;
    }

    public int getFieldsCount() {
        return this.getFieldList().size();
    }

    public int[] getFilters() {
        return this.filters;
    }

    public String getFiltersAsString() {
        String str = "";
        for (int i = 0; i < this.filters.length; ++i) {
            if (i != 0) {
                str = str + ",";
            }
            str = str + this.filters[i];
        }
        return str;
    }

    public Vector<FieldGroup> getGroups() {
        if (this.groups.size() == 0) {
            this.addGroup(this.createDefaultGroup());
        }
        return this.groups;
    }

    public String getIconName() {
        return this.iconName;
    }

    public IdFieldMeta getIdField() {
        if (this.idField == null) {
            throw new IllegalStateException("Primary field is required on table : " + this.getTableName());
        }
        return this.idField;
    }

    public String getListSql() {
        if (this.listSql == null) {
            return this.getShortReportSql();
        }
        return this.listSql;
    }

    public FieldMeta getLookupNumberField() {
        if (this.getIdField().isLookupNumber()) {
            return this.getIdField();
        }
        for (FieldMeta field : this.fieldList) {
            if (!field.isLookupNumber()) continue;
            return field;
        }
        return this.fieldList.get(0);
    }

    public String getManagePanelClassName() {
        return this.managePanelClassName;
    }

    public int getMaxRecordsCount() {
        return this.maxRecordsCount;
    }

    public int getPageRowCount() {
        return this.pageRowCount;
    }

    public String getPanelClassName() {
        return this.panelClassName;
    }

    public JKPrivilige getParentPrivilige() {
        return this.parentPrivilige;
    }

    public JKPrivilige getPrivilige() {
        return JKSecurityManager.createPrivilige(JKMessage.getCapitalized(this.getTableName()), this.getParentPrivilige());
    }

    public String getReportSql() {
        if (this.reportSql != null && this.reportSql.startsWith("@")) {
            String sql = JKIOUtil.readFile(this.reportSql.substring(1));
            if (sql != null) {
                return sql;
            }
            return this.getDefaultSql();
        }
        if (this.reportSql == null || this.reportSql.equals("")) {
            return this.getDefaultSql();
        }
        return this.reportSql;
    }

    public String getShortReportSql() {
        return this.shortReportSql == null ? this.getReportSql() : this.shortReportSql;
    }

    public String getSource() {
        return this.source;
    }

    public TableDataValidator getTableDataValidator() {
        if (this.tableDataValidator == null) {
            this.tableDataValidator = TableDataValidatorFactory.createValidator();
        }
        return this.tableDataValidator;
    }

    public String getTableId() {
        return this.tableId == null ? this.getTableName() : this.tableId;
    }

    public String getTableName() {
        return this.tableName;
    }

    public HashSet<String> getTriggerNames() {
        return this.triggerNames;
    }

    public ArrayList<Trigger> getTriggers() {
        if (this.triggers == null) {
            this.triggers = new ArrayList();
            if (this.triggerNames.size() > 0) {
                for (String triggerName : this.triggerNames) {
                    try {
                        Trigger trigger = (Trigger)Class.forName(triggerName).newInstance();
                        this.triggers.add(trigger);
                    }
                    catch (Exception e) {
                        JKExceptionUtil.handle(e);
                    }
                }
            }
        }
        return this.triggers;
    }

    public ArrayList<FieldMeta> getVisibleFields() {
        if (this.visibleFields == null) {
            this.visibleFields = new ArrayList();
            if (this.getIdField().isVisible()) {
                this.visibleFields.add(this.getIdField());
            }
            for (FieldMeta field : this.fieldList) {
                if (!field.isVisible()) continue;
                this.visibleFields.add(field);
            }
        }
        return this.visibleFields;
    }

    public int getVisibleFieldsCount() {
        return this.getVisibleFields().size();
    }

    public boolean isAllowAdd() {
        try {
            return this.allowAdd;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isAllowDelete() {
        try {
            return this.allowDelete;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isAllowDeleteAll() {
        try {
            return this.isAllowDelete();
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isAllowManage() {
        return this.allowManage;
    }

    public boolean isAllowUpdate() {
        try {
            return this.allowUpdate;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isAutoIncrementId() {
        return this.getIdField() != null && this.getIdField().isAutoIncrement();
    }

    public boolean isCaptionNull() {
        return this.caption == null || this.caption.trim().equals("");
    }

    public boolean isCrossTable() {
        return this.crossTable;
    }

    @Override
    public boolean isInline() {
        return true;
    }

    public boolean isListSqlNull() {
        return this.listSql == null || this.listSql.equals("") || this.listSql.toUpperCase().equals(this.getDefaultSql().toUpperCase());
    }

    public boolean isReportSqlNull() {
        return this.reportSql == null || this.reportSql.equals("") || this.reportSql.toUpperCase().equals(this.getDefaultSql().toUpperCase());
    }

    public boolean isShortSqlNull() {
        return this.shortReportSql == null || this.shortReportSql.equals("") || this.shortReportSql.toUpperCase().equals(this.getDefaultSql().toUpperCase());
    }

    public boolean isSingleRecord() {
        return this.getMaxRecordsCount() == 1;
    }

    public boolean isTableIdNull() {
        return this.tableId == null || this.tableId.trim().equals("") || this.tableId.equals(this.getTableName());
    }

    public ArrayList<ForiegnKeyFieldMeta> lstForiegnKeyFields() {
        ArrayList<ForiegnKeyFieldMeta> list = new ArrayList<ForiegnKeyFieldMeta>();
        for (int i = 0; i < this.fieldList.size(); ++i) {
            if (!(this.fieldList.get(i) instanceof ForiegnKeyFieldMeta)) continue;
            list.add((ForiegnKeyFieldMeta)this.fieldList.get(i));
        }
        return list;
    }

    public Vector<FieldMeta> lstSummaryFields() {
        Vector<FieldMeta> summaryFields = new Vector<FieldMeta>();
        for (int i = 0; i < this.fieldList.size(); ++i) {
            FieldMeta field = this.fieldList.get(i);
            if (!field.isSummaryField()) continue;
            summaryFields.add(field);
        }
        if (summaryFields.size() == 0) {
            summaryFields.add(this.fieldList.get(0));
        }
        return summaryFields;
    }

    public void setAllowAdd(boolean allowAdd) {
        this.allowAdd = allowAdd;
    }

    public void setAllowDelete(boolean allowDelete) {
        this.allowDelete = allowDelete;
    }

    public void setAllowManage(boolean allowManage) {
        this.allowManage = allowManage;
    }

    public void setAllowUpdate(boolean allowUpdate) {
        this.allowUpdate = allowUpdate;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setCaption(String caption) {
        if (caption != null && caption.trim().equals("\n")) {
            caption = null;
        }
        this.caption = caption;
    }

    public void setConstraints(ArrayList<Constraint> constraints) {
        this.constraints = constraints;
    }

    public void setCorssTable(boolean crossTable) {
        this.crossTable = crossTable;
    }

    public void setCrossTable(boolean crossTable) {
        this.crossTable = crossTable;
    }

    public void setDefaultUIRowCount(int defaultUIRowCount) {
        this.defaultUIRowCount = defaultUIRowCount;
    }

    public void setDetailFields(ArrayList<ForiegnKeyFieldMeta> detailFields) {
        this.detailFields = detailFields;
    }

    public void setFieldList(Vector<FieldMeta> fieldList) {
        this.fieldList = fieldList;
        for (int i = 0; i < fieldList.size(); ++i) {
            FieldMeta meta = fieldList.get(i);
            meta.setParentTable(this);
            this.fields.put(meta.getName(), meta);
        }
    }

    public void setFields(Hashtable<String, FieldMeta> fields) {
        this.fields = fields;
    }

    public void setFilters(String[] strings) {
        this.filters = new int[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            this.filters[i] = Integer.parseInt(strings[i]);
        }
    }

    public void setIconName(String iconName) {
        this.iconName = iconName;
    }

    public void setIdField(IdFieldMeta idField) {
        this.idField = idField;
        if (idField != null) {
            idField.setParentTable(this);
        }
    }

    public void setListSql(String listSql) {
        this.listSql = listSql;
    }

    public void setManagePanelClassName(String managePanelClassName) {
        this.managePanelClassName = managePanelClassName;
    }

    public void setMaxRecordsCount(int maxRecordsCount) {
        this.maxRecordsCount = maxRecordsCount;
    }

    public void setPageRowCount(int pageRowCount) {
        this.pageRowCount = pageRowCount;
    }

    public void setPanelClassName(String panelClassName) {
        this.panelClassName = panelClassName;
    }

    public void setParentPrivilige(JKPrivilige parentPrivilige) {
        this.parentPrivilige = parentPrivilige;
    }

    public void setReportSql(String reportSql) {
        this.reportSql = reportSql;
    }

    public void setShortReportSql(String shortReportSql) {
        this.shortReportSql = shortReportSql;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setTableDataValidator(TableDataValidator tableDataValidator) {
        this.tableDataValidator = tableDataValidator;
    }

    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setTriggerNames(HashSet<String> triggerNames) {
        this.triggerNames = triggerNames;
    }

    @Override
    public Object toQueryElement() {
        return this.getTableName();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Table name : " + this.tableName);
        buf.append(" , " + this.idField);
        buf.append(" ,\n\t " + this.fields);
        return buf.toString();
    }

    public void validateData(Record record) {
        this.getTableDataValidator().validate(this, record);
    }
}

