/*
 * Decompiled with CFR 0.152.
 */
package com.jk.metadata.db.meta;

import com.jk.locale.JKMessage;
import com.jk.metadata.db.meta.Field;
import com.jk.metadata.db.meta.FieldMeta;
import com.jk.metadata.db.meta.ForiegnKeyFieldMeta;
import com.jk.metadata.db.meta.IdFieldMeta;
import com.jk.metadata.db.meta.TableMeta;
import com.jk.util.JKConversionUtil;
import com.jk.util.JKObjectUtil;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;

public class Record {
    Field idField;
    boolean newRecord;
    boolean deleted;
    TableMeta tableMeta;
    ArrayList<Field> fields = new ArrayList();
    private boolean modified;
    String gui;

    public Record(TableMeta meta) {
        this.tableMeta = meta;
    }

    public void addField(Field field) {
        this.fields.add(field);
    }

    public String concatFieldsValue(String separator, String ... fieldNames) {
        StringBuffer buf = new StringBuffer();
        for (String fieldName : fieldNames) {
            buf.append(this.getFieldValue(fieldName).toString());
            buf.append(separator);
        }
        return buf.toString();
    }

    public Field getField(int index) {
        return this.fields.get(index);
    }

    public Field getField(String name) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!this.fields.get(i).getMeta().getName().equals(name)) continue;
            return this.fields.get(i);
        }
        return null;
    }

    public ArrayList<Field> getFields() {
        return this.fields;
    }

    public int getFieldsCount() {
        return this.fields.size();
    }

    public List<Object> getFieldsValues() {
        ArrayList<Object> objs = new ArrayList<Object>();
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.get(i);
            objs.add(field.getValueObject());
        }
        return objs;
    }

    public Object getFieldValue(String fieldName) {
        return this.getField(fieldName).getValueObject();
    }

    public Boolean getFieldValueAsBoolean(String fieldName) {
        return this.getField(fieldName).getValueAsBoolean();
    }

    public Date getFieldValueAsDate(String fieldName) {
        return JKConversionUtil.toDate(this.getFieldValue(fieldName));
    }

    public double getFieldValueAsDouble(String fieldName) {
        return this.getField(fieldName).getValueAsDouble();
    }

    public float getFieldValueAsFloat(String fieldName) {
        return this.getField(fieldName).getValueAsFloat();
    }

    public int getFieldValueAsInteger(String fieldName) {
        return this.getField(fieldName).getValueAsInteger();
    }

    public java.sql.Date getFieldValueAsSqlDate(String fieldName) {
        Date value = this.getFieldValueAsDate(fieldName);
        if (value != null) {
            return new java.sql.Date(value.getTime());
        }
        return null;
    }

    public String getFieldValueAsString(String fieldName) {
        return this.getField(fieldName).getValue();
    }

    public Time getFieldValueAsTime(String fieldName) {
        return JKConversionUtil.toTime(this.getFieldValue(fieldName));
    }

    public ArrayList<Object> getFieldValues() {
        ArrayList<Field> fields = this.getFields();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Field field : fields) {
            values.add(field.getValueObject());
        }
        return values;
    }

    public Field getForiegnKeyFieldByMasterFieldName(String masterFieldName) {
        for (int i = 0; i < this.fields.size(); ++i) {
            ForiegnKeyFieldMeta field;
            if (!(this.fields.get(i).getMeta() instanceof ForiegnKeyFieldMeta) || !(field = (ForiegnKeyFieldMeta)this.fields.get(i).getMeta()).getReferenceField().equals(masterFieldName)) continue;
            return this.fields.get(i);
        }
        return null;
    }

    public String getGui() {
        return this.gui;
    }

    public Field getIdField() {
        return this.idField;
    }

    public Object getIdValue() {
        return this.idField.getValue();
    }

    public int getIdValueAsInteger() {
        return this.idField.getValueAsInteger();
    }

    public String getSummaryValue() {
        throw new IllegalStateException("re-implement me");
    }

    public TableMeta getTableMeta() {
        return this.tableMeta;
    }

    public Field getVisibleField(int visibleIndex) {
        int counter = 0;
        for (Field field : this.fields) {
            if (!field.getMeta().isVisible() || counter++ != visibleIndex) continue;
            return field;
        }
        return null;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isIdAutoIncrement() {
        IdFieldMeta meta = (IdFieldMeta)this.getIdField().getMeta();
        return meta.isAutoIncrement();
    }

    public boolean isModified() {
        if (this.modified) {
            if (this.isNewRecord()) {
                for (Field field : this.fields) {
                    FieldMeta fieldMeta = field.getMeta();
                    String value = field.getValue();
                    if (!fieldMeta.isVisible() || value == null || value.equals("") || value.equals(fieldMeta.getDefaultValue())) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public boolean isNewRecord() {
        IdFieldMeta field = (IdFieldMeta)this.getIdField().getMeta();
        if (field.isAutoIncrement() && this.getIdValue() != null && !this.getIdValue().equals("")) {
            return false;
        }
        return this.newRecord;
    }

    public ArrayList<Field> lstSummaryFields() {
        ArrayList<Field> summaryFields = new ArrayList<Field>();
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.get(i);
            if (!field.getMeta().isSummaryField()) continue;
            summaryFields.add(field);
        }
        if (summaryFields.size() == 0 && this.fields.size() > 1) {
            summaryFields.add(this.fields.get(0));
            if (this.fields.size() > 2) {
                summaryFields.add(this.fields.get(1));
            }
        }
        return summaryFields;
    }

    public void prepareForAdd() {
        this.setIdValue(null);
        this.setModified(true);
        this.setNewRecord(true);
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
        if (deleted) {
            this.setModified(false);
        }
    }

    public void setFieldValue(String fieldName, Object value) {
        for (int i = 0; i < this.fields.size(); ++i) {
            if (!this.fields.get(i).getMeta().getName().equals(fieldName)) continue;
            this.fields.get(i).setValue(value);
            return;
        }
        throw new RuntimeException("Field " + fieldName + " didnt set in  this record");
    }

    public void setGui(String gui) {
        this.gui = gui;
    }

    public void setIdField(Field idField) {
        this.idField = idField;
    }

    public void setIdValue(Object value) {
        this.idField.setValue(value);
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void setNewRecord(boolean newRecord) {
        this.newRecord = newRecord;
    }

    public void setValues(boolean overwriteIfNull, Record ... records) {
        for (Record record : records) {
            for (Field field : this.fields) {
                if (record.getField(field.getFieldName()) == null || record.getFieldValue(field.getFieldName()) == null && !overwriteIfNull) continue;
                field.setValue(record.getFieldValue(field.getFieldName()));
            }
        }
    }

    public void setValues(Hashtable<String, Object> hash) {
        Enumeration<String> keys = hash.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (this.getField(key) == null) continue;
            this.setFieldValue(key, hash.get(key));
        }
    }

    public void setValues(Record ... record) {
        this.setValues(false, record);
    }

    public Object toObject() {
        if (this.getTableMeta().getBeanName() == null) {
            throw new IllegalStateException("Please set 'class' property for meta " + this.getTableMeta().getTableName());
        }
        Object bean = JKObjectUtil.newInstance(this.getTableMeta().getBeanName());
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        if (this.getIdField().getValueObject() != null) {
            map.put(this.getIdField().getMeta().getPropertyName(), this.getIdField().getValueObject());
        }
        ArrayList<Field> fields = this.getFields();
        for (Field field : fields) {
            if (field.getValueObject() == null) continue;
            if (field.getMeta() instanceof ForiegnKeyFieldMeta) {
                ForiegnKeyFieldMeta meta = (ForiegnKeyFieldMeta)field.getMeta();
                TableMeta referenceTableMeta = meta.getReferenceTableMeta();
                if (referenceTableMeta.getBeanName() != null) {
                    Record record = referenceTableMeta.createEmptyRecord();
                    record.setIdValue(field.getValueObject());
                    map.put(field.getMeta().getPropertyName(), record.toObject());
                    continue;
                }
                System.err.println("Error while set property for field " + field.getFieldName());
                System.err.println(" class property is null for meta " + referenceTableMeta.getTableName());
                continue;
            }
            map.put(field.getMeta().getPropertyName(), field.getValueObject());
        }
        JKObjectUtil.populate(bean, map);
        return bean;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean valuesOnly) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.fields.size(); ++i) {
            Field field = this.fields.get(i);
            if (valuesOnly) {
                buffer.append(JKMessage.get(field.getFieldName(), new Object[0]));
                buffer.append(" : ");
                buffer.append(field.getValue() == null ? "-" : field.getValue());
            } else {
                buffer.append(field.toString());
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

