/*
 * Decompiled with CFR 0.152.
 */
package com.jk.metadata.db.meta;

import com.jk.metadata.db.meta.FieldMeta;
import com.jk.metadata.db.query.Operator;
import com.jk.metadata.db.query.QueryComponent;
import com.jk.util.JKStringUtil;
import java.util.Date;

public class Field
implements QueryComponent {
    FieldMeta meta;
    Object value;

    public Field(FieldMeta meta) {
        this.meta = meta;
    }

    public Field(FieldMeta meta, Object value) {
        this.setMeta(meta);
        this.setValue(value);
    }

    public String getDatabaseString() {
        if (this.getValue() == null) {
            return "NULL";
        }
        return "'" + JKStringUtil.escapeValue(this.getValue()) + "'";
    }

    public String getFieldName() {
        return this.getMeta().getName();
    }

    public FieldMeta getMeta() {
        return this.meta;
    }

    public String getSqlEquality() {
        if (this.getValue() == null) {
            return "" + this.meta.getName() + " IS NULL ";
        }
        return "" + this.meta.getName() + " = '" + this.getValue().toString() + "'";
    }

    public String getValue() {
        return this.getValue(null);
    }

    public String getValue(String defalutValue) {
        if (this.value == null) {
            return defalutValue;
        }
        return this.value.toString();
    }

    public Boolean getValueAsBoolean() {
        if (this.getValue() == null) {
            return false;
        }
        if (this.getValueObject() instanceof Boolean) {
            return (boolean)((Boolean)this.getValueObject());
        }
        return this.getValueObject().toString().equals("1");
    }

    public double getValueAsDouble() {
        return this.getValueAsDouble(-1.0f);
    }

    public double getValueAsDouble(float defaultValue) {
        if (this.getValue() == null || this.getValue().trim().equals("")) {
            return defaultValue;
        }
        if (this.getMeta().getType() == 91 || this.getMeta().getType() == 92) {
            Date date = (Date)this.getValueObject();
            return date.getTime();
        }
        return Double.parseDouble(this.getValue());
    }

    public float getValueAsFloat() {
        return this.getValueAsFloat(-1.0f);
    }

    public float getValueAsFloat(float defaultValue) {
        if (this.getValue() == null || this.getValue().trim().equals("")) {
            return defaultValue;
        }
        if (this.getMeta().getType() == 91 || this.getMeta().getType() == 92) {
            Date date = (Date)this.getValueObject();
            return date.getTime();
        }
        return Float.parseFloat(this.getValue());
    }

    public int getValueAsInteger() {
        return this.getValueAsInteger(-1);
    }

    public int getValueAsInteger(int defaultValue) {
        return this.getValue() == null || this.getValue().trim().equals("") ? defaultValue : Integer.parseInt(this.getValue());
    }

    public Object getValueObject() {
        return this.value;
    }

    public Object getValueObject(Object defaultValue) {
        return this.getValueObject() == null ? defaultValue : this.getValueObject();
    }

    public boolean isEmpty() {
        return this.getValue() == null || this.getValue().toString().equals("");
    }

    @Override
    public boolean isInline() {
        return true;
    }

    public boolean isVisible() {
        return this.getMeta().isVisible();
    }

    public void setMeta(FieldMeta meta) {
        this.meta = meta;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public Object toQueryElement() {
        return this.getMeta().getFullQualifiedName() + Operator.EQUAL + this.getValue();
    }

    public String toSqlEquality() {
        String value = JKStringUtil.escapeValue(this.getValue());
        if (this.getValue() == null || this.getValue().equals("")) {
            return this.meta.getName() + "='' OR " + this.meta.getName() + " IS NULL";
        }
        return this.meta.getName() + "='" + (this.getValue() == null ? "" : value) + "'";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.meta.toString() + " - Value = ");
        buffer.append(this.value);
        return buffer.toString();
    }
}

