/*
 * Decompiled with CFR 0.152.
 */
package com.jk.metadata.db.constraints;

import com.jk.metadata.db.constraints.Constraint;
import com.jk.metadata.db.exceptions.DataOutOfRangeException;
import com.jk.metadata.db.meta.Field;
import com.jk.metadata.db.meta.FieldMeta;
import com.jk.metadata.db.meta.Record;
import java.util.ArrayList;

public class DataRangeConstraint
extends Constraint {
    float valueFrom;
    float valueTo;

    @Override
    public String getTypeString() {
        return "range";
    }

    public float getValueFrom() {
        return this.valueFrom;
    }

    public float getValueTo() {
        return this.valueTo;
    }

    public void setValueFrom(float valueFrom) {
        this.valueFrom = valueFrom;
    }

    public void setValueTo(float valueTo) {
        this.valueTo = valueTo;
    }

    @Override
    public String toString() {
        return this.getName() + "Data Range Constraint ";
    }

    @Override
    public void validate(Record record) {
        ArrayList<FieldMeta> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            float value;
            FieldMeta fieldMeta = fields.get(i);
            Field field = record.getField(fieldMeta.getName());
            if (field.getValue() == null || field.getValue().equals("") || !((value = Float.parseFloat(field.getValue())) < this.valueFrom) && !(value > this.valueTo)) continue;
            DataOutOfRangeException ex = new DataOutOfRangeException("OUT_OF_RANGE", this);
            ex.addField(field);
            throw ex;
        }
    }
}

