/*
 * Decompiled with CFR 0.152.
 */
package com.jk.mail;

import com.jk.mail.Attachment;
import com.jk.util.JKConversionUtil;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.mail.ByteArrayDataSource;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.MultiPartEmail;

public class MailInfo {
    String host = System.getProperty("jk-mail-host", "smtp.gmail.com");
    boolean requiresAuthentication = JKConversionUtil.toBoolean(System.getProperty("jk-mail-host-auth", "true"));
    boolean secured = JKConversionUtil.toBoolean(System.getProperty("jk-mail-secured", "true"));
    private String username = System.getProperty("jk-mail-user");
    private String password = System.getProperty("jk-mail-password");
    private int smtpPort = JKConversionUtil.toInteger(System.getProperty("jk-mail-smtp-port", "587"));
    String from;
    String to;
    String subject;
    String msg;
    ArrayList<Attachment> attachements = new ArrayList();

    public void addAttachment(Attachment attachment) {
        this.attachements.add(attachment);
    }

    public void fillEmail(MultiPartEmail email) throws EmailException, IOException {
        email.setHostName(this.getHost());
        email.setSmtpPort(this.getSmtpPort());
        email.addTo(this.getTo());
        email.setFrom(this.getFrom());
        email.setSubject(this.getSubject());
        email.setMsg(this.getMsg());
        email.setSSLOnConnect(this.isSecured());
        if (this.isRequiresAuthentication()) {
            email.setAuthentication(this.getUsername(), this.getPassword());
        }
        for (int i = 0; i < this.attachements.size(); ++i) {
            Attachment attachment = this.attachements.get(i);
            ByteArrayDataSource ds = new ByteArrayDataSource(attachment.getData(), attachment.getMimeType());
            email.attach(ds, attachment.getName(), attachment.getDescription());
        }
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public boolean isRequiresAuthentication() {
        return this.requiresAuthentication;
    }

    public void setRequiresAuthentication(boolean requiresAuthentication) {
        this.requiresAuthentication = requiresAuthentication;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    private String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFrom() {
        return this.from;
    }

    public String getHost() {
        return this.host;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getTo() {
        return this.to;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }
}

