/*
 * Decompiled with CFR 0.152.
 */
package com.jk.exceptions.handler;

import com.jk.annotations.AnnotationDetector;
import com.jk.exceptions.handler.ExceptionHandler;
import com.jk.exceptions.handler.JKDefaultExceptionHandler;
import com.jk.exceptions.handler.JKExceptionHandler;
import com.jk.exceptions.handler.JKExceptionHandlerInfo;
import com.jk.exceptions.handler.JKExceptionUtil;
import com.jk.util.JKObjectUtil;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;

public class JKExceptionHandlerFactory {
    private static JKExceptionHandlerFactory instance;
    private JKExceptionHandler defaultExceptionHandler = new JKDefaultExceptionHandler();
    private final LinkedHashMap<Class<? extends Throwable>, JKExceptionHandler> handlers = new LinkedHashMap();

    public static JKExceptionHandlerFactory getInstance() {
        if (instance == null) {
            instance = new JKExceptionHandlerFactory();
        }
        return instance;
    }

    public JKExceptionHandler getDefaultHandler() {
        return this.defaultExceptionHandler;
    }

    public JKExceptionHandlerInfo getHandler(Class<? extends Throwable> clas) {
        JKExceptionHandler handler = this.handlers.get(clas);
        if (handler != null) {
            JKExceptionHandlerInfo info = new JKExceptionHandlerInfo();
            info.setExceptionClass(clas).setHandler(handler);
            return info;
        }
        return null;
    }

    public <T extends Throwable> JKExceptionHandlerInfo getHandler(T t) {
        JKExceptionHandlerInfo info = this.getHandler((T)((Object)t.getClass()));
        if (info != null) {
            info.setException(t);
        }
        if (info == null && t.getCause() != null) {
            info = this.getHandler(t.getCause());
        }
        return info;
    }

    public void setDefaultExceptionHandler(JKExceptionHandler defaultExceptionHandler) {
        this.defaultExceptionHandler = defaultExceptionHandler;
    }

    public void setHandler(Class<? extends Throwable> clas, JKExceptionHandler handler) {
        this.handlers.put(clas, handler);
    }

    public void registerHanders(String packageString) {
        List<String> list = AnnotationDetector.scanAsList(ExceptionHandler.class, packageString);
        for (String handler : list) {
            JKExceptionHandler newInstance = (JKExceptionHandler)JKObjectUtil.newInstance(handler);
            Class clas = JKObjectUtil.getGenericParamter(handler);
            this.setHandler(clas, newInstance);
        }
    }

    public static void main(String[] args) {
        JKExceptionHandlerFactory.getInstance().registerHanders("com.jk.annotations");
        JKExceptionUtil.handle(new IOException("test exception"));
    }
}

