/*
 * Decompiled with CFR 0.152.
 */
package com.jk.exceptions;

import com.jk.exceptions.JKException;
import java.net.ConnectException;
import java.net.UnknownHostException;

public class JKServerDownException
extends JKException {
    private static final long serialVersionUID = -2582331807098593228L;
    private int port;
    private String host;

    public JKServerDownException(Exception ex, String host, int port) {
        super(ex);
        this.host = host;
        this.port = port;
    }

    public JKServerDownException(Throwable cause) {
        super(cause);
    }

    public String getHost() {
        return this.host;
    }

    @Override
    public String getMessage() {
        if (this.getCause() instanceof UnknownHostException) {
            return "Host (" + this.getHost() + ") is unreachable !!!!";
        }
        if (this.getCause() instanceof ConnectException) {
            return "Host (" + this.getHost() + ") is unreachable at Port (" + this.getPort() + ")!!!!";
        }
        return this.getCause().getMessage();
    }

    public int getPort() {
        return this.port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

