/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.util;

import com.jk.desktop.swing.comp.JKTree;
import com.jk.desktop.swing.tree.TreeCheckBoxNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeUtil {
    public static String getExpansionState(JTree tree, int row) {
        TreePath rowPath = tree.getPathForRow(row);
        StringBuffer buf = new StringBuffer();
        int rowCount = tree.getRowCount();
        for (int i = row; i < rowCount; ++i) {
            TreePath path = tree.getPathForRow(i);
            if (i != row && !TreeUtil.isDescendant(path, rowPath)) break;
            if (!tree.isExpanded(path)) continue;
            buf.append("," + String.valueOf(i - row));
        }
        return buf.toString();
    }

    public static boolean isDescendant(TreePath path1, TreePath path2) {
        int count2;
        int count1 = path1.getPathCount();
        if (count1 <= (count2 = path2.getPathCount())) {
            return false;
        }
        while (count1 != count2) {
            path1 = path1.getParentPath();
            --count1;
        }
        return path1.equals(path2);
    }

    public static void refreshNode(JTree tree, TreeNode node) {
        ((DefaultTreeModel)tree.getModel()).nodeStructureChanged(node);
    }

    public static void restoreExpanstionState(JTree tree, int row, String expansionState) {
        StringTokenizer stok = new StringTokenizer(expansionState, ",");
        while (stok.hasMoreTokens()) {
            int token = row + Integer.parseInt(stok.nextToken());
            tree.expandRow(token);
        }
    }

    public static void setParentSelected(JKTree tree, TreeCheckBoxNode checkBoxNode, boolean selected) {
        if (checkBoxNode.getParent() != null && checkBoxNode.getParent() instanceof TreeCheckBoxNode) {
            TreeCheckBoxNode parent = (TreeCheckBoxNode)checkBoxNode.getParent();
            parent.setSelected(selected);
            TreeUtil.setParentSelected(tree, parent, selected);
        }
    }

    public static void setSelected(JTree tree, TreeNode treeNode, boolean selected, boolean includeChilds) {
        if (treeNode instanceof TreeCheckBoxNode) {
            TreeCheckBoxNode checkBoxNode = (TreeCheckBoxNode)treeNode;
            checkBoxNode.setSelected(selected);
        }
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            TreeNode child = treeNode.getChildAt(i);
            TreeUtil.setSelected(tree, child, selected, true);
        }
    }

    public static ArrayList<TreeNode> toArray(TreeNode node) {
        ArrayList<TreeNode> list = new ArrayList<TreeNode>();
        list.add(node);
        Enumeration<? extends TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            TreeNode nextNode = children.nextElement();
            list.addAll(TreeUtil.toArray(nextNode));
        }
        return list;
    }
}

