/*
 * Decompiled with CFR 0.152.
 */
package com.jk.desktop.util;

import com.jk.desktop.swing.SwingUtility;
import com.jk.locale.JKMessage;
import com.jk.util.JKIOUtil;
import com.jk.util.model.table.JKTableModel;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.text.SimpleDateFormat;

public class TableModelHtmlBuilder {
    private static String companyName;
    private static File logoFile;
    static SimpleDateFormat format;
    private JKTableModel model;
    private boolean showCounter = true;
    String reportTitle;

    public static String getCompanyName() {
        return companyName;
    }

    public static void main(String[] args) throws IOException {
    }

    public static void setCompanyLogo(byte[] logo) {
        if (logo != null) {
            logoFile = JKIOUtil.writeDataToTempFile(logo, ".jpg");
        }
    }

    public static void setCompanyName(String name) {
        companyName = name;
    }

    public TableModelHtmlBuilder(JKTableModel model, String title) {
        this(model, title, true);
    }

    public TableModelHtmlBuilder(JKTableModel model, String title, boolean showCounter) {
        this.model = model;
        this.showCounter = showCounter;
        this.reportTitle = title;
    }

    private Object buildColunmsRow() {
        StringBuffer buf = new StringBuffer();
        buf.append("<tr>");
        buf.append(this.buildDataCell("#"));
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            if (!this.model.isVisible(i)) continue;
            String cell = this.buildDataCell(JKMessage.get(this.model.getActualColumnName(i), new Object[0]), true);
            buf.append(cell);
        }
        buf.append("</tr>\n");
        return buf.toString();
    }

    private String buildDataCell(String data) {
        return this.buildDataCell(data, false);
    }

    private String buildDataCell(String data, boolean bold) {
        String string = data = data == null || data.equals("") ? "-" : data;
        if (bold) {
            data = "<b>" + data + "</b>";
        }
        return "<td nowrap>" + data + "</td>\n";
    }

    private Object buildDataRow(int rowIndex) {
        StringBuffer buf = new StringBuffer("<tr>");
        buf.append(this.buildDataCell(rowIndex + 1 + ""));
        for (int i = 0; i < this.model.getColumnCount(); ++i) {
            String value;
            if (!this.model.isVisible(i)) continue;
            Object valueAt = this.model.getValueAt(rowIndex, i);
            String string = value = valueAt == null ? "-" : valueAt.toString();
            if (this.model.getColumnType(i) == 91 && value != null) {
                value = format.format(Date.valueOf(value));
            }
            buf.append(this.buildDataCell(value));
        }
        buf.append("</tr>");
        return buf.toString();
    }

    private String buildDataTable() {
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            buf.append(this.buildDataRow(i));
        }
        return buf.toString();
    }

    public String buildHtml() {
        StringBuffer buf = new StringBuffer("<html " + this.getPageDirection() + ">");
        buf.append("<head>\n");
        buf.append("<title>" + this.getReportTitle() + "</title>");
        buf.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=windows-1256\" />");
        buf.append("</head>");
        buf.append("<body >\n");
        buf.append(this.getReportHeader());
        buf.append("<table border=1 cellpadding=2 cellspacing=0 align=center>\n");
        buf.append(this.buildColunmsRow());
        buf.append(this.buildDataTable());
        buf.append("</table>\n");
        buf.append("</body>\n");
        buf.append("</html>\n");
        return buf.toString();
    }

    public JKTableModel getModel() {
        return this.model;
    }

    private String getPageDirection() {
        return SwingUtility.isLeftOrientation() ? "" : " dir='rtl' ";
    }

    protected String getReportHeader() {
        StringBuffer header = new StringBuffer("");
        header.append("<div align=center style='font-family: Arial;font-size: 14pt;font-weight: bold;'>\n");
        if (companyName != null) {
            header.append(companyName);
        }
        header.append("<br>");
        if (logoFile != null && logoFile.getAbsolutePath() != null) {
            header.append("<img src='" + logoFile.getAbsolutePath() + "' />");
            header.append("<p>");
        }
        header.append("</div>\n");
        if (this.reportTitle != null) {
            header.append("<h1 align=center>");
            header.append(this.reportTitle);
            header.append("</h1>\n");
        }
        return header.toString();
    }

    public String getReportTitle() {
        return this.reportTitle;
    }

    public boolean isShowCounter() {
        return this.showCounter;
    }

    public void setModel(JKTableModel model) {
        this.model = model;
    }

    public void setReportTitle(String reportTitle) {
        this.reportTitle = reportTitle;
    }

    public void setShowCounter(boolean showCounter) {
        this.showCounter = showCounter;
    }

    static {
        format = new SimpleDateFormat(SwingUtility.getDatePattern());
    }
}

